﻿<#
    .SYNOPSIS
        Private option utilities module

    .DESCRIPTION
        This file defines functions for private operations
#>

# 基本パス関連 ( 全部文字列型らしい [string] )
$MyScriptPath          = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyScriptPath)
$BasicModulePath       = "${MyScriptDirectoryPath}\..\..\..\SystemUpdateBasic\Scripts\Modules"

Import-Module "${BasicModulePath}\PlatformUtilities"

# SDK ROOTパス
$NintendoSdkRootPath = $(Find-NintendoSdkRootPath)

# -----------------------------------------------------------------------
# Get a count of system contents that has been installed in the target box.
# -----------------------------------------------------------------------
function Get-CountOfInstalledSystemContent( [string]$defPlatform, [string]$defBuildType, [string]$TargetName, [string]$TargetAddress )
{
    # DevMenuCommandSystem.nsp の検索
    [string] $nspDevMenuCommandSystem = $(Search-AvailableDevMenuCommandSystem ${NintendoSdkRootPath} ${defPlatform} ${defBuildType})
    Write-Host "DevMenuCommandSystem: ${nspDevMenuCommandSystem}"

    # ターゲットボックスの検索
    if ([string]::IsNullOrEmpty($TargetAddress)) {
        if ([string]::IsNullOrEmpty($TargetName)) {
            throw "TargetAddress and TargetName not specified"
        } else {
            $TargetAddress = Get-TargetAddressFromSerial $TargetName
        }
    }

    # ターゲットボックスへの接続要求
    Write-Host "start connection...: ${TargetAddress}"
    [string] $exeControlTarget = "${NintendoSdkRootPath}\Tools\CommandLineTools\ControlTarget.exe"
    Invoke-Expression "& `"${exeControlTarget}`" connect -t ${TargetAddress}" | Write-Host
    if ( $LastExitCode -eq 0 )
    {
        Write-Host "Connected. Wait a boot sequence complete."

        # 起動完了しログが安定しないと期待しない文字列がRunOnTargetから返されてしまうので、起動完了まで 30秒待ちます。
        #Start-Sleep -s 30
        [string] $exeRunOnTargetPrivate = "${NintendoSdkRootPath}\Tools\CommandLineTools\RunOnTargetPrivate.exe"
        $defResponseStream = Invoke-Expression "& `"${exeRunOnTargetPrivate}`" run `"--target`" `"${TargetAddress}`" `"${nspDevMenuCommandSystem}`" `"systemprogram`" `"list`" --hostbridge `"${TargetAddress}`""
        $defMatchResult = [regex]::Match(${defResponseStream}, "[0-9]+ system content meta\(s\) found\.")
        if ( $defMatchResult.Success )
        {
            $defMatchedValue = $defMatchResult.Value
            $defLineValues = ${defMatchedValue} -csplit "system"
            if ( $defLineValues.Length -gt 0 ) 
            {
                $defCountString = $defLineValues[0]
                return [System.UInt32] $defCountString.Trim()
            }
        }
        throw "Could not found the count information in response stream.`n  -> `"${defResponseStream}`""
    }
    throw "Target connection failed. ExitCode = $LastExitCode"
}
Export-ModuleMember -Function Get-CountOfInstalledSystemContent
