﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <cstdlib>
#include <nn/nn_Common.h>

#if defined( NN_BUILD_CONFIG_OS_WIN )

//!--------------------------------------------------------------------------------------
//! @brief The implementation in C11 rules for aligned memory allocations.@n
//!        Memory allocator with alignment for start address of rules on the windows operating system.
//!--------------------------------------------------------------------------------------
NN_FORCEINLINE static void* aligned_alloc( size_t beginAlignment, size_t size ) NN_NOEXCEPT
{
    return ::_aligned_malloc( size, beginAlignment );
}

//!--------------------------------------------------------------------------------------
//! @brief The implementation for aligned memory release rules on the windows operating system.
//!--------------------------------------------------------------------------------------
NN_FORCEINLINE static void aligned_free( void* address ) NN_NOEXCEPT
{
    ::_aligned_free( address );
}

#else   // NX, Cafe, and C++11 supported platforms...

//!--------------------------------------------------------------------------------------
//! @brief The implementation for aligned memory release that has been imitated on the rules of the windows operating system.
//!--------------------------------------------------------------------------------------
NN_FORCEINLINE static void aligned_free( void* address ) NN_NOEXCEPT
{
    ::free( address );
}

#endif
