﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <string>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nsutil/nsutil_InstallUtils.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <curl/curl.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/fs/fs_Bis.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>
#include <nn/socket.h>

#include <nn/nifm.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/nim/nim_Result.h>
#include <nn/ovln/ovln_ForDevelop.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_ApiForDfc.h>
#include <nn/npns.h>
#include <nn/npns/npns_ApiSystem.h>

#include <nn/ns/srv/ns_PushNotificationDisptcher.h>

#include "../../../Programs/Eris/Sources/Libraries/nssrv/ns_NotificationToken.h"

#include <nn/nifm/nifm_ApiForSystem.h>

using namespace nn;

namespace {

    class RegisterNotificationTokenTest : public testing::Test, public nnt::nsutil::ApplicationInstaller
    {
    public:

    protected:
        virtual void SetUp()
        {
            npns::InitializeForSystem();
            nim::InitializeForNetworkInstallManager();
            WaitNpnsConnected();
        }

        virtual void TearDown()
        {
            nim::FinalizeForNetworkInstallManager();
            npns::FinalizeForSystem();
        }

        static void SetUpTestCase()
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(nifm::InitializeSystem());
        }

        static void TearDownTestCase()
        {
        }

    private:
        void WaitNpnsConnected()
        {
            npns::State state;
            os::SystemEvent stateChangedEvent;
            npns::GetStateChangeEvent(stateChangedEvent);
            while ((state = npns::GetState()) != npns::State_Connected)
            {
                auto result = stateChangedEvent.TimedWait(TimeSpan::FromSeconds(20));
                NN_ABORT_UNLESS(result);
            }
        }
    };

    Result TestRegisterNotificationToken(ns::srv::NotificationTokenCreationTask& task, os::SystemEvent* cancelEvent)
    {
        while (NN_STATIC_CONDITION(true))
        {
            NN_RESULT_TRY(task.Process(cancelEvent))
                NN_RESULT_CATCH(nim::ResultOutOfMaxRunningTask)
                {
                    NN_LOG("* NotificationTokenCreationTask Retry\n");
                    os::SleepThread(TimeSpan::FromSeconds(1));
                    continue;
                }
            NN_RESULT_END_TRY;

            NN_RESULT_SUCCESS;
        }
    }

} // namespace


TEST_F(RegisterNotificationTokenTest, Basic)
{
    ns::srv::NotificationTokenCreationTask task(true);
    os::SystemEvent cancelEvent(os::EventClearMode_ManualClear, false);

    NNT_EXPECT_RESULT_SUCCESS(TestRegisterNotificationToken(task, &cancelEvent));
}

TEST_F(RegisterNotificationTokenTest, Cancel)
{
    ns::srv::NotificationTokenCreationTask task(true);
    os::SystemEvent cancelEvent(os::EventClearMode_ManualClear, false);
    cancelEvent.Signal();

    NNT_EXPECT_RESULT_FAILURE(ns::ResultCanceled, TestRegisterNotificationToken(task, &cancelEvent));
}
