﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/util/util_ScopeExit.h>


#include <new>
#include <nn/nifm.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/ns/ns_DocumentApi.h>
#include <nn/ns/ns_DownloadTaskSystemApi.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_SystemUpdateApi.h>


void* operator new(size_t size) {
    // グローバルの new が呼ばれているならシムレイヤのメモリ管理を間違っているのでエラー
    ADD_FAILURE();
    return malloc(size);
}

TEST(InitializeTest, ApplicationManagerAllocation)
{
    nn::ns::Initialize();
    NN_UTIL_SCOPE_EXIT{ nn::ns::Finalize(); };

    nn::nifm::Initialize();
    nn::nifm::SubmitNetworkRequestAndWait();

    // IApplicationManager
    {
        nn::ns::ApplicationRecord record;
        nn::ns::ListApplicationRecord(&record, 1, 0);

        {
            nn::ns::AsyncResult ar;
            nn::ns::RequestDownloadApplicationControlData(&ar, { 0 });
            ar.Get();
        }

        {
            nn::ns::AsyncResult ar;
            nn::ns::RequestUpdateApplication(&ar, { 0 });
        }
    }
}

TEST(InitializeTest, FunctionsAllocation)
{
    nn::ns::Initialize();
    NN_UTIL_SCOPE_EXIT{ nn::ns::Finalize(); };

    nn::nifm::Initialize();
    nn::nifm::SubmitNetworkRequestAndWait();

    // IContentManagement
    {
        int64_t size;
        NNT_EXPECT_RESULT_SUCCESS(nn::ns::GetTotalSpaceSize(&size, nn::ncm::StorageId::BuildInUser));
    }

    // IDocument
    {
        NNT_EXPECT_RESULT_FAILURE(nn::ns::ResultApplicationNotRunning, nn::ns::MountApplicationHtmlDocument("test", { 0 }));
    }

    // IDownload
    {
        nn::ns::ClearTaskStatusList();
    }
}

TEST(InitializeTest, SystemUpdateAllocation)
{
    nn::ns::Initialize();
    NN_UTIL_SCOPE_EXIT{ nn::ns::Finalize(); };

    nn::nifm::Initialize();
    nn::nifm::SubmitNetworkRequestAndWait();

    // ISystemUpdate
    {
        nn::ns::SystemUpdateControl sc;
        sc.Occupy();
    }
}
