﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_InitializationApi.h>

extern "C" void nnMain()
{
    nn::ns::Initialize();

    nn::os::SystemEvent event;
    nn::ns::GetApplicationShellEvent(&event);

    NN_LOG("GetApplicationShellEvent done.\n");

    while(NN_STATIC_CONDITION(true))
    {
        event.Wait();

        nn::ns::ApplicationShellEventInfo infoList[32];
        while(NN_STATIC_CONDITION(true))
        {
            auto listCount = sizeof(infoList) / sizeof(infoList[0]);
            auto count = nn::ns::PopApplicationShellEventInfo(infoList, listCount);
            for(int i = 0; i < count; i++)
            {
                NN_LOG("event %u\n", infoList[i].event);
                NN_LOG("processId 0x%016llx\n", infoList[i].processId);
            }
            if(count < listCount)
            {
                break;
            }
        }
    }
}

