﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <map>
#include <nn/nn_Common.h>

class Option
{
public:
    Option() NN_NOEXCEPT;
    ~Option() NN_NOEXCEPT;

    static bool SetArgument(int argc, char** argv) NN_NOEXCEPT;

    static const char* GetInputFilePath() NN_NOEXCEPT
    {
        return m_InputFilePath.c_str();
    }

    static bool HasKey(const char* key) NN_NOEXCEPT;
    static const char* GetValue(const char* key) NN_NOEXCEPT;

private:
    static std::string m_InputFilePath;
    static std::map<std::string, std::string> m_Map;
};

