﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ApplicationManagerTestTool_Option.h"

std::string Option::m_InputFilePath;
std::map<std::string, std::string> Option::m_Map;

Option::Option() NN_NOEXCEPT
{
}

Option::~Option() NN_NOEXCEPT
{
}

bool Option::SetArgument(int argc, char** argv) NN_NOEXCEPT
{
    m_InputFilePath = argv[1];

    for (int i = 2; i < argc; ++i)
    {
        if (argv[i][0] == '-')
        {
            if (i + 1 >= argc || argv[i + 1][0] == '-')
            {
                m_Map[argv[i]] = "";
            }
            else
            {
                m_Map[argv[i]] = argv[i + 1];
                ++i;
            }
        }
    }

    return true;
}

bool Option::HasKey(const char* key) NN_NOEXCEPT
{
    return m_Map.find(key) != m_Map.cend();
}

const char* Option::GetValue(const char* key) NN_NOEXCEPT
{
    auto it = m_Map.find(key);
    return it != m_Map.cend() ? (*it).second.c_str() : nullptr;
}
