﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ApplicationManagerTestTool_NsTypeConverter.h"

const char* NsTypeConv::ToString(nn::ns::StartupUserAccount inStartupUserAccount) NN_NOEXCEPT
{
    switch (inStartupUserAccount)
    {
    case nn::ns::StartupUserAccount::None:                                       return "None";
    case nn::ns::StartupUserAccount::Required:                                   return "Required";
    case nn::ns::StartupUserAccount::RequiredWithNetworkServiceAccountAvailable: return "RequiredWithNetworkServiceAccountAvailable";
    default: return "";
    }
}

nn::ns::StartupUserAccount NsTypeConv::ToStartupUserAccount(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::StartupUserAccount::None;

    if      (inStr == "None")                                       { ret = nn::ns::StartupUserAccount::None; }
    else if (inStr == "Required")                                   { ret = nn::ns::StartupUserAccount::Required; }
    else if (inStr == "RequiredWithNetworkServiceAccountAvailable") { ret = nn::ns::StartupUserAccount::RequiredWithNetworkServiceAccountAvailable; }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::AttributeFlag inAttributeFlag) NN_NOEXCEPT
{
    switch (inAttributeFlag)
    {
    case nn::ns::AttributeFlag::Demo: return "Demo";
    default: return "";
    }
}

nn::ns::AttributeFlag NsTypeConv::ToAttributeFlag(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = static_cast<nn::ns::AttributeFlag>(0x00000000);

    if (inStr == "Demo")
    {
        ret = nn::ns::AttributeFlag::Demo;
    }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::ParentalControlFlag inParentalControlFlag) NN_NOEXCEPT
{
    switch (inParentalControlFlag)
    {
    case nn::ns::ParentalControlFlag::FreeCommunication: return "FreeCommunication";
    default: return "";
    }
}

nn::ns::ParentalControlFlag NsTypeConv::ToParentalControlFlag(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = static_cast<nn::ns::ParentalControlFlag>(0x00000000);

    if (inStr == "FreeCommunication")
    {
        ret = nn::ns::ParentalControlFlag::FreeCommunication;
    }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::Screenshot inScreenshot) NN_NOEXCEPT
{
    switch (inScreenshot)
    {
    case nn::ns::Screenshot::Allow: return "Allow";
    case nn::ns::Screenshot::Deny:  return "Deny";
    default: return "";
    }
}

nn::ns::Screenshot NsTypeConv::ToScreenshot(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::Screenshot::Allow;

    if      (inStr == "Allow") { ret = nn::ns::Screenshot::Allow; }
    else if (inStr == "Deny")  { ret = nn::ns::Screenshot::Deny; }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::VideoCapture inVideoCapture) NN_NOEXCEPT
{
    switch (inVideoCapture)
    {
    case nn::ns::VideoCapture::Disable: return "Disable";
    case nn::ns::VideoCapture::Manual:  return "Manual";
    case nn::ns::VideoCapture::Enable:  return "Enable";
    default: return "";
    }
}

nn::ns::VideoCapture NsTypeConv::ToVideoCapture(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::VideoCapture::Enable;

    if      (inStr == "Disable") { ret = nn::ns::VideoCapture::Disable; }
    else if (inStr == "Manual")  { ret = nn::ns::VideoCapture::Manual; }
    else if (inStr == "Enable")  { ret = nn::ns::VideoCapture::Enable; }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::LogoType inLogoType) NN_NOEXCEPT
{
    switch (inLogoType)
    {
    case nn::ns::LogoType::LicensedByNintendo:    return "LicensedByNintendo";
    case nn::ns::LogoType::Nintendo:              return "Nintendo";
    default: return "";
    }
}

nn::ns::LogoType NsTypeConv::ToLogoType(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::LogoType::LicensedByNintendo;

    if      (inStr == "LicensedByNintendo")    { ret = nn::ns::LogoType::LicensedByNintendo; }
    else if (inStr == "Nintendo")              { ret = nn::ns::LogoType::Nintendo; }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::RatingOrganization inRatingOrganization) NN_NOEXCEPT
{
    switch (inRatingOrganization)
    {
    case nn::ns::RatingOrganization::CERO:         return "CERO";
    case nn::ns::RatingOrganization::GRACGCRB:     return "GRACGCRB";
    case nn::ns::RatingOrganization::GSRMR:        return "GSRMR";
    case nn::ns::RatingOrganization::ESRB:         return "ESRB";
    case nn::ns::RatingOrganization::ClassInd:     return "ClassInd";
    case nn::ns::RatingOrganization::USK:          return "USK";
    case nn::ns::RatingOrganization::PEGI:         return "PEGI";
    case nn::ns::RatingOrganization::PEGIPortugal: return "PEGIPortugal";
    case nn::ns::RatingOrganization::PEGIBBFC:     return "PEGIBBFC";
    case nn::ns::RatingOrganization::Russian:      return "Russian";
    case nn::ns::RatingOrganization::ACB:          return "ACB";
    case nn::ns::RatingOrganization::OFLC:         return "OFLC";
    default: return "";
    }
}

nn::ns::RatingOrganization NsTypeConv::ToRatingOrganization(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::RatingOrganization::CERO;

    if      (inStr == "CERO")         { ret = nn::ns::RatingOrganization::CERO; }
    else if (inStr == "GRACGCRB")     { ret = nn::ns::RatingOrganization::GRACGCRB; }
    else if (inStr == "GSRMR")        { ret = nn::ns::RatingOrganization::GSRMR; }
    else if (inStr == "ESRB")         { ret = nn::ns::RatingOrganization::ESRB; }
    else if (inStr == "ClassInd")     { ret = nn::ns::RatingOrganization::ClassInd; }
    else if (inStr == "USK")          { ret = nn::ns::RatingOrganization::USK; }
    else if (inStr == "PEGI")         { ret = nn::ns::RatingOrganization::PEGI; }
    else if (inStr == "PEGIPortugal") { ret = nn::ns::RatingOrganization::PEGIPortugal; }
    else if (inStr == "PEGIBBFC")     { ret = nn::ns::RatingOrganization::PEGIBBFC; }
    else if (inStr == "Russian")      { ret = nn::ns::RatingOrganization::Russian; }
    else if (inStr == "ACB")          { ret = nn::ns::RatingOrganization::ACB; }
    else if (inStr == "OFLC")         { ret = nn::ns::RatingOrganization::OFLC; }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::DataLossConfirmation inDataLossConfirmation) NN_NOEXCEPT
{
    switch (inDataLossConfirmation)
    {
    case nn::ns::DataLossConfirmation::None:     return "None";
    case nn::ns::DataLossConfirmation::Required: return "Required";
    default: return "";
    }
}

nn::ns::DataLossConfirmation NsTypeConv::ToDataLossConfirmation(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::DataLossConfirmation::None;

    if      (inStr == "None")     { ret = nn::ns::DataLossConfirmation::None; }
    else if (inStr == "Required") { ret = nn::ns::DataLossConfirmation::Required; }

    return ret;
}


const char* NsTypeConv::ToString(nn::ns::PlayLogPolicy inPlayLogPolicy) NN_NOEXCEPT
{
    switch (inPlayLogPolicy)
    {
    case nn::ns::PlayLogPolicy::All:     return "All";
    case nn::ns::PlayLogPolicy::LogOnly: return "LogOnly";
    case nn::ns::PlayLogPolicy::None:    return "None";
    default: return "";
    }
}

nn::ns::PlayLogPolicy NsTypeConv::ToPlayLogPolicy(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::PlayLogPolicy::All;

    if      (inStr == "All")     { ret = nn::ns::PlayLogPolicy::All; }
    else if (inStr == "LogOnly") { ret = nn::ns::PlayLogPolicy::LogOnly; }
    else if (inStr == "None")    { ret = nn::ns::PlayLogPolicy::None; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::LogoHandling inLogoHandling) NN_NOEXCEPT
{
    switch (inLogoHandling)
    {
    case nn::ns::LogoHandling::Auto:   return "Auto";
    case nn::ns::LogoHandling::Manual: return "Manual";
    default: return "";
    }
}

nn::ns::LogoHandling NsTypeConv::ToLogoHandling(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::LogoHandling::Auto;

    if (inStr == "Auto")     { ret = nn::ns::LogoHandling::Auto; }
    else if (inStr == "Manual") { ret = nn::ns::LogoHandling::Manual; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::AddOnContentRegistrationType inAocRegistrationType) NN_NOEXCEPT
{
    switch (inAocRegistrationType)
    {
    case nn::ns::AddOnContentRegistrationType::AllOnLaunch: return "AllOnLaunch";
    case nn::ns::AddOnContentRegistrationType::OnDemand:    return "OnDemand";
    default: return "";
    }
}

nn::ns::AddOnContentRegistrationType NsTypeConv::ToAddOnContentRegistrationType(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::AddOnContentRegistrationType::OnDemand;

    if (inStr == "AllOnLaunch")   { ret = nn::ns::AddOnContentRegistrationType::AllOnLaunch; }
    else if (inStr == "OnDemand") { ret = nn::ns::AddOnContentRegistrationType::OnDemand; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::Hdcp inHdcp) NN_NOEXCEPT
{
    switch (inHdcp)
    {
    case nn::ns::Hdcp::None:     return "None";
    case nn::ns::Hdcp::Required: return "Required";
    default: return "";
    }
}

nn::ns::Hdcp NsTypeConv::ToHdcp(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::Hdcp::None;

    if (inStr == "None")   { ret = nn::ns::Hdcp::None; }
    else if (inStr == "Required") { ret = nn::ns::Hdcp::Required; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::CrashReport inCR) NN_NOEXCEPT
{
    switch (inCR)
    {
    case nn::ns::CrashReport::Allow: return "Allow";
    case nn::ns::CrashReport::Deny:  return "Deny";
    default: return "";
    }
}

nn::ns::CrashReport NsTypeConv::ToCrashReport(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::CrashReport::Deny;

    if (inStr == "Allow") { ret = nn::ns::CrashReport::Allow; }
    else if (inStr == "Deny") { ret = nn::ns::CrashReport::Deny; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::RuntimeAddOnContentInstall inRuntimeAocInstall) NN_NOEXCEPT
{
    switch (inRuntimeAocInstall)
    {
    case nn::ns::RuntimeAddOnContentInstall::Deny:        return "Deny";
    case nn::ns::RuntimeAddOnContentInstall::AllowAppend: return "AllowAppend";
    default: return "";
    }
}

nn::ns::RuntimeAddOnContentInstall NsTypeConv::ToRuntimeAddOnContentInstall(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::RuntimeAddOnContentInstall::Deny;

    if (inStr == "Deny")             { ret = nn::ns::RuntimeAddOnContentInstall::Deny; }
    else if (inStr == "AllowAppend") { ret = nn::ns::RuntimeAddOnContentInstall::AllowAppend; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::PlayLogQueryCapability inPlayLogQueryCapability) NN_NOEXCEPT
{
    switch (inPlayLogQueryCapability)
    {
    case nn::ns::PlayLogQueryCapability::None:      return "None";
    case nn::ns::PlayLogQueryCapability::WhiteList: return "WhiteList";
    case nn::ns::PlayLogQueryCapability::All:       return "All";
    default: return "";
    }
}

nn::ns::PlayLogQueryCapability NsTypeConv::ToPlayLogQueryCapability(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::PlayLogQueryCapability::None;

    if (inStr == "None")           { ret = nn::ns::PlayLogQueryCapability::None; }
    else if (inStr == "WhiteList") { ret = nn::ns::PlayLogQueryCapability::WhiteList; }
    else if (inStr == "All")       { ret = nn::ns::PlayLogQueryCapability::All; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ns::RepairFlag inRepairFlag) NN_NOEXCEPT
{
    auto flag = static_cast<nn::Bit8>(inRepairFlag);
    switch (flag)
    {
    case 0x0: return "None";
    case static_cast<nn::Bit8>(nn::ns::RepairFlag::SuppressGameCardAccess): return "SuppressGameCardAccess";
    default: return "";
    }
}

nn::ns::RepairFlag NsTypeConv::ToRepairFlag(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = static_cast<nn::ns::RepairFlag>(0x0);

    if (inStr == "None")                        { ret = static_cast<nn::ns::RepairFlag>(0x0); }
    else if (inStr == "SuppressGameCardAccess") { ret = nn::ns::RepairFlag::SuppressGameCardAccess; }

    return ret;
}

const std::string NsTypeConv::RequiredNetworkServiceLicenseOnLaunchFlagToString(nn::Bit8 bitflag) NN_NOEXCEPT
{
    if (bitflag == 0x0)
    {
        return "None";
    }

    const int flagCount = 8;
    const char* flagName[flagCount] = {
        "Common",
        "undefined2",
        "undefined3",
        "undefined4",
        "undefined5",
        "undefined6",
        "undefined7",
        "undefined8",
    };

    std::string str;
    auto isFlagged = false;
    for (int i = 0; i < flagCount; i++)
    {
        if (bitflag & (0x1 << i))
        {
            if (isFlagged == true)
            {
                str += ", ";
            }
            isFlagged = true;

            str += flagName[i];
        }
    }

    return str;
}

nn::Bit8 NsTypeConv::ToRequiredNetworkServiceLicenseOnLaunchFlag(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ns::RequiredNetworkServiceLicenseOnLaunchFlag::None;

    if (inStr == "None") { ret = nn::ns::RequiredNetworkServiceLicenseOnLaunchFlag::None; }
    else if (inStr == "Common") { ret = nn::ns::RequiredNetworkServiceLicenseOnLaunchFlag::Common; }

    return static_cast<nn::Bit8>(ret);
}

const char* NsTypeConv::ToString(nn::settings::Language inLanguage) NN_NOEXCEPT
{
    switch (inLanguage)
    {
    case nn::settings::Language::Language_Japanese:             return "Japanese";
    case nn::settings::Language::Language_AmericanEnglish:      return "AmericanEnglish";
    case nn::settings::Language::Language_German:               return "German";
    case nn::settings::Language::Language_French:               return "French";
    case nn::settings::Language::Language_Italian:              return "Italian";
    case nn::settings::Language::Language_Spanish:              return "Spanish";
    case nn::settings::Language::Language_SimplifiedChinese:    return "SimplifiedChinese";
    case nn::settings::Language::Language_Korean:               return "Korean";
    case nn::settings::Language::Language_Dutch:                return "Dutch";
    case nn::settings::Language::Language_Portuguese:           return "Portuguese";
    case nn::settings::Language::Language_Russian:              return "Russian";
    case nn::settings::Language::Language_TraditionalChinese:   return "TraditionalChinese";
    case nn::settings::Language::Language_BritishEnglish:       return "BritishEnglish";
    case nn::settings::Language::Language_CanadianFrench:       return "CanadianFrench";
    case nn::settings::Language::Language_LatinAmericanSpanish: return "LatinAmericanSpanish";
    default: return "";
    }
}

nn::settings::Language NsTypeConv::ToSettingLanguage(const std::string& inLangageStr) NN_NOEXCEPT
{
    auto lang = nn::settings::Language_AmericanEnglish;

    if      (inLangageStr == "Japanese")             { lang = nn::settings::Language_Japanese; }
    else if (inLangageStr == "AmericanEnglish")      { lang = nn::settings::Language_AmericanEnglish; }
    else if (inLangageStr == "German")               { lang = nn::settings::Language_German; }
    else if (inLangageStr == "French")               { lang = nn::settings::Language_French; }
    else if (inLangageStr == "Italian")              { lang = nn::settings::Language_Italian; }
    else if (inLangageStr == "Spanish")              { lang = nn::settings::Language_Spanish; }
    else if (inLangageStr == "SimplifiedChinese")    { lang = nn::settings::Language_SimplifiedChinese; }
    else if (inLangageStr == "Korean")               { lang = nn::settings::Language_Korean; }
    else if (inLangageStr == "Dutch")                { lang = nn::settings::Language_Dutch; }
    else if (inLangageStr == "Portuguese")           { lang = nn::settings::Language_Portuguese; }
    else if (inLangageStr == "Russian")              { lang = nn::settings::Language_Russian; }
    else if (inLangageStr == "TraditionalChinese")   { lang = nn::settings::Language_TraditionalChinese; }
    else if (inLangageStr == "BritishEnglish")       { lang = nn::settings::Language_BritishEnglish; }
    else if (inLangageStr == "CanadianFrench")       { lang = nn::settings::Language_CanadianFrench; }
    else if (inLangageStr == "LatinAmericanSpanish") { lang = nn::settings::Language_LatinAmericanSpanish; }

    return lang;
}

const char* NsTypeConv::ToString(nn::ncm::StorageId inStorageId) NN_NOEXCEPT
{
    switch (inStorageId)
    {
    case nn::ncm::StorageId::None:          return "None";
    case nn::ncm::StorageId::Host:          return "Host";
    case nn::ncm::StorageId::Card:          return "Card";
    case nn::ncm::StorageId::BuildInSystem: return "BuildInSystem";
    case nn::ncm::StorageId::BuildInUser:   return "BuildInUser";
    case nn::ncm::StorageId::SdCard:        return "SdCard";
    case nn::ncm::StorageId::Any:           return "Any";
    default: return "";
    }
}

nn::ncm::StorageId NsTypeConv::ToStorageIdForInstallStorage(const std::string& inStr) NN_NOEXCEPT
{
    auto ret = nn::ncm::StorageId::None;

    if (inStr == "builtin")     { ret = nn::ncm::StorageId::BuildInUser; }
    else if (inStr == "sdcard") { ret = nn::ncm::StorageId::SdCard; }

    return ret;
}

const char* NsTypeConv::ToString(nn::ncm::ContentMetaType inContentMetaType) NN_NOEXCEPT
{
    switch (inContentMetaType)
    {
    case nn::ncm::ContentMetaType::Unknown:              return "Unknown";
    case nn::ncm::ContentMetaType::SystemProgram:        return "SystemProgram";
    case nn::ncm::ContentMetaType::SystemData:           return "SystemData";
    case nn::ncm::ContentMetaType::SystemUpdate:         return "SystemUpdate";
    case nn::ncm::ContentMetaType::BootImagePackage:     return "BootImagePackage";
    case nn::ncm::ContentMetaType::BootImagePackageSafe: return "BootImagePackageSafe";
    case nn::ncm::ContentMetaType::Application:          return "Application";
    case nn::ncm::ContentMetaType::Patch:                return "Patch";
    case nn::ncm::ContentMetaType::AddOnContent:         return "AddOnContent";
    case nn::ncm::ContentMetaType::Delta:                return "Delta";
    default: return "";
    }
}
