﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>

class HtcUtil
{
public:
    HtcUtil() NN_NOEXCEPT {}
    ~HtcUtil() NN_NOEXCEPT {}

    static void Initialize() NN_NOEXCEPT;
    static void Finalize() NN_NOEXCEPT;

    /**
    *   @brief      環境変数で指定された文字列を、環境変数の値に置換します。
    *
    *   @param[in]  inPath    置換対象のパス文字列
    *
    *   @return     置換後のパス文字列が返ります。
    *               環境変数が指定されていない(存在しない)場合は引数の値がそのまま返されます。
    */
    static std::string ReplaceEnvironmentVariable(const std::string& inPath) NN_NOEXCEPT;
};
