﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <vector>
#include <set>
#include <nn/nn_Common.h>

#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationContentMetaApi.h>

// typedef の代替記法(C++11)
using ContentMetaStatusList = std::vector<nn::ns::ApplicationContentMetaStatus>;

struct TestProperty
{
    nn::ns::ApplicationView view;
    nn::ns::ApplicationOccupiedSize size;
    nn::ns::ApplicationControlProperty controlProperty;
    bool isLaunchRights;
    std::vector<std::pair<nn::ncm::StorageId, bool> > movableList;
};

class AppOperation
{
public:
    AppOperation() NN_NOEXCEPT;
    virtual ~AppOperation() NN_NOEXCEPT;

    static void Initialize() NN_NOEXCEPT;

public:
    static nn::Result Install(const std::string& inNspFilePath, const std::string& inInstallStorage) NN_NOEXCEPT;

    static nn::Result GetViewList(std::vector<nn::ns::ApplicationView>& outList) NN_NOEXCEPT;
    static nn::Result GetTestPropertyList(std::vector<TestProperty>& outList) NN_NOEXCEPT;
    static nn::Result GetInstalledIdList(std::set<nn::Bit64>& outList) NN_NOEXCEPT;

    static nn::Result Uninstall(nn::ncm::ApplicationId inAppId) NN_NOEXCEPT;
    static nn::Result UninstallAll() NN_NOEXCEPT;

    static void ClearCache() NN_NOEXCEPT;

    static nn::Result GetHostStorageSize(int64_t& outFreeSize, int64_t& outTotalSize) NN_NOEXCEPT;
    static nn::Result GetBuiltInStorageSize(int64_t& outFreeSize, int64_t& outTotalSize) NN_NOEXCEPT;
    static nn::Result GetSdCardStorageSize(int64_t& outFreeSize, int64_t& outTotalSize) NN_NOEXCEPT;

    static bool IsMovable(nn::ncm::ApplicationId inAppId, const std::string& inDstStorage) NN_NOEXCEPT;
    static nn::Result MoveApplication(nn::ncm::ApplicationId inAppId, const std::string& inDstStorage) NN_NOEXCEPT;

    static int CountContentMeta(nn::ncm::ApplicationId inAppId) NN_NOEXCEPT;
    static nn::Result GetContentMetaStatus(nn::ncm::ApplicationId inAppId, ContentMetaStatusList& outMetaStatusList) NN_NOEXCEPT;

    static nn::Result CleanupSdCard() NN_NOEXCEPT;
    static nn::Result FormatSdCard() NN_NOEXCEPT;
    static nn::Result MeasureApplicationManagerTime() NN_NOEXCEPT;

private:
    static std::vector<nn::ncm::StorageId> m_TestStorageIdList;
};

