﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/nifm.h>
#include <nn/socket.h>
#include <nn/nn_Assert.h>
#include <nn/nn_BitTypes.h>
#include <nn/es/es_Types.h>
#include <nn/es/es_InitializationApi.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/spl/spl_Api.h>
#include <nnt/nntest.h>
#include <curl/curl.h>
#include <nn/result/result_HandlingUtility.h>
#include "nim_NetworkInstallUtil.h"

namespace {
    class DownloadCommonTicketTest : public testing::Test
    {
    protected:
        nn::nim::srv::DeviceContext deviceContext;
        nn::nim::srv::HttpConnection connection;

        DownloadCommonTicketTest()
        {
            deviceContext.Initialize();
            connection.Initialize(&deviceContext);
        }

        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }

        static void SetUpTestCase()
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::Initialize());
            nn::nifm::SubmitNetworkRequestAndWait();

            static NN_ALIGNAS(4096) uint8_t s_SocketMemoryPoolBuffer[nn::socket::DefaultSocketMemoryPoolSize];
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::socket::Initialize(reinterpret_cast<void*>(s_SocketMemoryPoolBuffer),
                nn::socket::DefaultSocketMemoryPoolSize,
                nn::socket::DefaultSocketAllocatorSize,
                nn::socket::DefaultConcurrencyLimit));
            auto result = curl_global_init(CURL_GLOBAL_ALL);
            NN_ASSERT_EQUAL(CURLE_OK, result);

            nn::es::Initialize();

#ifdef NN_BUILD_CONFIG_OS_HORIZON
            nn::spl::Initialize();
#endif

        }

        static void TearDownTestCase()
        {
            curl_global_cleanup();
            nn::socket::Finalize();

            nn::nifm::CancelNetworkRequest();

            nn::es::Finalize();

#ifdef NN_BUILD_CONFIG_OS_HORIZON
            nn::spl::Finalize();
#endif
        }
    };
}

TEST_F(DownloadCommonTicketTest, Download)
{
    nn::es::RightsIdIncludingKeyId rightsId = { { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } };
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nim::srv::GetAndInstallCommonTicket(&connection, rightsId));
}
