﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/os.h>
#include <nn/fs.h>
#include <nn/nn_Assert.h>
#include <nn/nifm/nifm_Api.h>
#include <nn/util/util_StringUtil.h>

#include <nn/nifm/detail/util/nifm_SsidListUtility.h>

TEST(Strtokc, Basic)
{
    {
        char string[] = "a,b,c,d,e,f,g,h";
        char tokenizedString[][2] = { "a", "b", "c", "d", "e", "f", "g", "h" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, ',');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, ',')) != nullptr);
    }

    {
        char string[] = "aa,bb,cc,dddd";
        char tokenizedString[][5] = { "aa", "bb", "cc", "dddd" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, ',');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, ',')) != nullptr);
    }

    {
        char string[] = "aa/b/ccc/dd";
        char tokenizedString[][4] = { "aa", "b", "ccc", "dd" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, '/');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, '/')) != nullptr);
    }

    {
        char string[] = "aa\\b\\ccc\\dd";
        char tokenizedString[][4] = { "aa", "b", "ccc", "dd" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, '\\');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, '\\')) != nullptr);
    }
}

TEST(Strtokc, BasicWithEmptyItem)
{
    {
        char string[] = "a,b,c,d,e,f,,h";
        char tokenizedString[][2] = { "a", "b", "c", "d", "e", "f", "", "h" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, ',');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, ',')) != nullptr);
    }

    {
        char string[] = "aa,,cc,dddd";
        char tokenizedString[][5] = { "aa", "", "cc", "dddd" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, ',');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, ',')) != nullptr);
    }

    {
        char string[] = "/b/ccc/dd";
        char tokenizedString[][4] = { "", "b", "ccc", "dd" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, '/');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, '/')) != nullptr);
    }

    {
        char string[] = "aa\\b\\ccc\\";
        char tokenizedString[][4] = { "aa", "b", "ccc", "" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, '\\');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, '\\')) != nullptr);
    }

    {
        char string[] = "&&&&&&&&&";
        char tokenizedString[][2] = { "", "", "", "", "", "", "", "", "", "" };
        int i = 0;

        char* p = nn::nifm::detail::Strtokc(string, '&');

        do
        {
            ASSERT_NE(nullptr, p);
            ASSERT_EQ(0, nn::util::Strncmp(tokenizedString[i], p, nn::util::Strnlen(p, sizeof(string))));
            ++i;
        } while ((p = nn::nifm::detail::Strtokc(nullptr, '&')) != nullptr);
    }
}
