﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/socket.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/os.h>

#include <nn/nifm/detail/core/connectionConfirmation/nifm_ConnectionTestClient.h>
#include <nn/nifm/detail/core/connectionConfirmation/nifm_AuthenticationClient.h>

#include <nn/util/util_StringUtil.h>

namespace
{
    NN_ALIGNAS(4096) uint8_t g_SocketMemoryPoolBuffer[nn::socket::MinSocketMemoryPoolSize * 2];
}

class ConnectionTest : public ::testing::Test
{
protected:
    static void SetUpTestCase() {  }
    static void TearDownTestCase() { }
    virtual void TearDown() { }
};


TEST(ConnectionTest, Basic)
{
    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::Initialize());
    NNT_ASSERT_RESULT_SUCCESS(nn::socket::Initialize(reinterpret_cast<void*>(g_SocketMemoryPoolBuffer), nn::socket::MinSocketMemoryPoolSize * 2, nn::socket::MinSocketAllocatorSize * 2, 1));

    nn::nifm::NetworkConnection networkConnection;
    networkConnection.SubmitRequestAndWait();

    {
        nn::nifm::detail::ConnectionTestClient connectionTestClient;
        NNT_ASSERT_RESULT_SUCCESS(connectionTestClient.ConfirmInternetConnection(nn::nifm::detail::ConnectionTestClient::ConnTestUrl));

        const char redirectFromUrl[] = "http://developer.nintendo.com/";
        //const char redirectToUrl[]   = "https://developer.nintendo.com/";
        NNT_ASSERT_RESULT_FAILURE(nn::nifm::ResultConnectionTestHttpStatusFound, connectionTestClient.ConfirmInternetConnection(redirectFromUrl));

        //nn::nifm::detail::AuthenticationClient authenticationClient(connectionTestClient.GetRedirectUrlPointer());
        //NNT_ASSERT_RESULT_FAILURE(nn::nifm::ResultWisprAuthFailedWithRedirectUrl, authenticationClient.Authenticate());

        // TODO: NASサーバに NX 向けの API が実装され後
        // - WISPr 認証
        // - Web 認証アプレット
        // ...
    }

    NNT_ASSERT_RESULT_SUCCESS(nn::socket::Finalize());
}
