﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nfp.h>

void InitializeWriter();
void WriteProcess();
void WriteProcess(const char* process);
void WriteProcess(nn::Result result);
void WriteProcess(nn::nfp::DeviceState deviceState);
void WriteProcess(const nn::nfp::TagInfo& tagInfo,
                  const nn::nfp::ModelInfo& modelInfo,
                  const nn::nfp::CommonInfo& commonInfo,
                  bool hasRegisterInfo, const nn::nfp::RegisterInfo& registerInfo,
                  const void* applicationArea, size_t applicationAreaSize);
