﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nfp.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include "testNfp_MenuRender.h"

//================================================================================
// このファイルで使用する定義です。
//================================================================================
namespace
{
    #define GET_TEXT_POINT(point)   ((point) / 8)

    const int MenuDisplayNum = 2;
    const int MenuRowMax = 100;
    const int MenuColumnMax = 40;
    char g_MenuBuffer[MenuDisplayNum][MenuColumnMax][MenuRowMax];
    RenderDisplay g_TargetDisplay = RenderDisplay_0;

}

//================================================================================
// メニュー描画を実施する関数です。
//================================================================================

void MenuRenderSystem::Initialize(char* pHeap,const int heapSize) NN_NOEXCEPT
{
    NN_UNUSED(pHeap);
    NN_UNUSED(heapSize);
    std::memset(g_MenuBuffer,0x00,sizeof(g_MenuBuffer));
}

void MenuRenderSystem::Finalize() NN_NOEXCEPT
{
    return;
}

void MenuRenderSystem::SetClearColor(RenderDisplay targetDisplay,
                                     const float red,
                                     const float green,
                                     const float blue,
                                     const float alpha) NN_NOEXCEPT
{
    NN_UNUSED(targetDisplay);
    NN_UNUSED(red);
    NN_UNUSED(green);
    NN_UNUSED(blue);
    NN_UNUSED(alpha);
}

void MenuRenderSystem::SetColor(const float red,
                                const float green,
                                const float blue,
                                const float alpha) NN_NOEXCEPT
{
    NN_UNUSED(red);
    NN_UNUSED(green);
    NN_UNUSED(blue);
    NN_UNUSED(alpha);
}

void MenuRenderSystem::SetFontSize(const int size) NN_NOEXCEPT
{
    NN_UNUSED(size);
}

void MenuRenderSystem::SetLineWidth(const float width) NN_NOEXCEPT
{
    NN_UNUSED(width);
}

void MenuRenderSystem::WaitVsync(RenderDisplay targetDisplay) NN_NOEXCEPT
{
    //コンソール出力でのメニュー表示時用に画面をクリアする
    //GUIメニューを作成したら削除予定
    NNT_CLEAR_MENU();

    if(targetDisplay & RenderDisplay_0)
    {
        for(int column = 0;column < MenuColumnMax;column++)
        {
            if(g_MenuBuffer[0][column][0] == 0x00)
            {
                continue;
            }
            NNT_PRINT_MENU("%s\n",g_MenuBuffer[0][column]);
        }
    }

    NNT_PRINT_MENU("-------------------------------\n");

    if(targetDisplay & RenderDisplay_1)
    {
        for(int column = 0;column < MenuColumnMax;column++)
        {
            if(g_MenuBuffer[1][column][0] == 0x00)
            {
                continue;
            }
            NNT_PRINT_MENU("%s\n",g_MenuBuffer[1][column]);
        }
    }
}

void MenuRenderSystem::SetRenderTarget(RenderDisplay targetDisplay) NN_NOEXCEPT
{
    g_TargetDisplay = targetDisplay;
}

void MenuRenderSystem::Clear() NN_NOEXCEPT
{
    if(g_TargetDisplay & RenderDisplay_0)
    {
        std::memset(g_MenuBuffer[0], 0x00, sizeof(g_MenuBuffer) / 2);
    }

    if(g_TargetDisplay & RenderDisplay_1)
    {
        std::memset(g_MenuBuffer[1], 0x00, sizeof(g_MenuBuffer) / 2);
    }
}

void MenuRenderSystem::DrawText(int x, int y, const char* pText) NN_NOEXCEPT
{
    if(g_TargetDisplay & RenderDisplay_0)
    {
        for(int row = 0;row < GET_TEXT_POINT(x);row++)
        {
            //文字を挿入する場所の前に終端文字があった場合、半角スペースに変換する
            if(g_MenuBuffer[0][GET_TEXT_POINT(y)][row] == 0x00)
            {
                g_MenuBuffer[0][GET_TEXT_POINT(y)][row] = ' ';
            }
        }
        std::strcpy(&g_MenuBuffer[0][GET_TEXT_POINT(y)][GET_TEXT_POINT(x)],pText);
    }

    if(g_TargetDisplay & RenderDisplay_1)
    {
        for(int row = 0;row < GET_TEXT_POINT(x);row++)
        {
            //文字を挿入する場所の前に終端文字があった場合、半角スペースに変換する
            if(g_MenuBuffer[1][GET_TEXT_POINT(y)][row] == 0x00)
            {
                g_MenuBuffer[1][GET_TEXT_POINT(y)][row] = ' ';
            }
        }
        std::strcpy(&g_MenuBuffer[1][GET_TEXT_POINT(y)][GET_TEXT_POINT(x)],pText);
    }
}

void MenuRenderSystem::SwapBuffers() NN_NOEXCEPT
{

}

