﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testNews_Common.h"
#include <nn/news/detail/service/core/news_PassphraseManager.h>

using namespace nn::news::detail::service::core;

TEST(ReceivedHistoryManager, Initialize)
{
    nn::time::Initialize();

    ASSERT_RESULT_SUCCESS(nnt::news::MountSystemStorage(0x8000000000000099));
}

TEST(PassphraseManager, Clear)
{
    // 複数回呼出確認。
    PassphraseManager::GetInstance().Clear();
    PassphraseManager::GetInstance().Clear();
}

TEST(PassphraseManager, NotFound)
{
    nn::ApplicationId appId;

    char passphrase[nn::news::PassphraseLengthMax + 1];

    EXPECT_RESULT(PassphraseManager::GetInstance().Get(&appId, passphrase, sizeof (passphrase)), nn::news::ResultPassphraseNotSaved);
}

TEST(PassphraseManager, Save)
{
    nn::ApplicationId appId = {0x1234567812345678};

    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa50"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa51"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa52"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa53"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa54"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa55"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa56"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa57"));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa58"));
}

TEST(PassphraseManager, Get)
{
    nn::ApplicationId appId;

    char passphrase[nn::news::PassphraseLengthMax + 1];

    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Get(&appId, passphrase, sizeof (passphrase)));

    EXPECT_TRUE(appId.value == 0x1234567812345678);
    EXPECT_TRUE(nn::util::Strnlen(passphrase, nn::news::PassphraseLengthMax + 1) == 64);
    EXPECT_TRUE(nn::util::Strncmp(passphrase, "54427ae7d85e4f96bfc10ac79b94ed7b756e3d74fc514e0eafcf3342dc85fa58", nn::news::PassphraseLengthMax + 1) == 0);
}

TEST(PassphraseManager, MinMax)
{
    nn::ApplicationId appId = {0x1234567812345678};

    EXPECT_RESULT_FAILURE(PassphraseManager::GetInstance().Save(appId, ""));
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, "1"));

    char passphrase[nn::news::PassphraseLengthMax + 2] = {};

    for (int i = 0; i < nn::news::PassphraseLengthMax + 1; i++)
    {
        passphrase[i] = '1';
    }

    EXPECT_RESULT_FAILURE(PassphraseManager::GetInstance().Save(appId, passphrase));

    passphrase[nn::news::PassphraseLengthMax] = '\0';
    EXPECT_RESULT_SUCCESS(PassphraseManager::GetInstance().Save(appId, passphrase));
}

TEST(PassphraseManager, Finalize)
{
    nn::time::Finalize();

    nnt::news::UnmountSystemStorage();
}
