﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testNews_Common.h"
#include <nn/news/detail/service/core/news_AccountCountryChecker.h>

using namespace nn::news::detail::service::core;

TEST(CountryListQueryString, Zero)
{
    Account::Country countries[nn::account::UserCountMax] = {{""}};

    AccountCountryChecker::QueryString queryString;
    AccountCountryChecker::ConvertCountryListToCountryQueryString(&queryString, countries, 0);

    EXPECT_TRUE(nn::util::Strncmp(queryString.value, "", sizeof (queryString.value)) == 0);
}

TEST(CountryListQueryString, One)
{
    Account::Country countries[nn::account::UserCountMax] = {{"JP"}};

    AccountCountryChecker::QueryString queryString;
    AccountCountryChecker::ConvertCountryListToCountryQueryString(&queryString, countries, 1);

    EXPECT_TRUE(nn::util::Strncmp(queryString.value, "c%5b%5d=JP", sizeof (queryString.value)) == 0);
}

TEST(CountryListQueryString, Max)
{
    Account::Country countries[nn::account::UserCountMax] = {{"11"}, {"22"}, {"33"}, {"44"}, {"55"}, {"66"}, {"77"}, {"88"}};

    AccountCountryChecker::QueryString queryString;
    AccountCountryChecker::ConvertCountryListToCountryQueryString(&queryString, countries, 8);

    EXPECT_TRUE(nn::util::Strncmp(queryString.value,
        "c%5b%5d=11&c%5b%5d=22&c%5b%5d=33&c%5b%5d=44&c%5b%5d=55&c%5b%5d=66&c%5b%5d=77&c%5b%5d=88", sizeof (queryString.value)) == 0);
}

TEST(CountryListQueryString, Duplicate)
{
    Account::Country countries[nn::account::UserCountMax] = {{"JP"}, {"JP"}, {"JP"}, {"JP"}};

    AccountCountryChecker::QueryString queryString;
    AccountCountryChecker::ConvertCountryListToCountryQueryString(&queryString, countries, 4);

    EXPECT_TRUE(nn::util::Strncmp(queryString.value, "c%5b%5d=JP", sizeof (queryString.value)) == 0);
}

TEST(CountryListQueryString, Sort1)
{
    Account::Country countries[nn::account::UserCountMax] = {{"JP"}, {"CA"}, {"US"}};

    AccountCountryChecker::QueryString queryString;
    AccountCountryChecker::ConvertCountryListToCountryQueryString(&queryString, countries, 3);

    EXPECT_TRUE(nn::util::Strncmp(queryString.value, "c%5b%5d=CA&c%5b%5d=JP&c%5b%5d=US", sizeof (queryString.value)) == 0);
}

TEST(CountryListQueryString, Sort2)
{
    Account::Country countries[nn::account::UserCountMax] = {{"CA"}, {"US"}, {"JP"}, {"CA"}, {"JP"}, {"US"}};

    AccountCountryChecker::QueryString queryString;
    AccountCountryChecker::ConvertCountryListToCountryQueryString(&queryString, countries, 6);

    EXPECT_TRUE(nn::util::Strncmp(queryString.value, "c%5b%5d=CA&c%5b%5d=JP&c%5b%5d=US", sizeof (queryString.value)) == 0);
}
