﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testNews_Common.h"

namespace nnt { namespace news {

/*!
    @brief      システム情報ストレージをマウントします。

    @param[in]  id  システム情報ストレージのシステムセーブデータ ID。

    @return     処理結果。

    @details
                NN_DETAIL_NEWS_SYSTEM_STORAGE_MOUNT_ALWAYS = 0 の場合、本関数は何も行いません。@n
                NN_DETAIL_NEWS_SYSTEM_STORAGE_MOUNT_ALWAYS は nn/news/detail/service/core/news_FileSystemConfig.h で定義されます。
*/
nn::Result MountSystemStorage(nn::fs::SystemSaveDataId id) NN_NOEXCEPT;

/*!
    @brief      システム情報ストレージをアンマウントします。

    @details
                NN_DETAIL_NEWS_SYSTEM_STORAGE_MOUNT_ALWAYS = 0 の場合、本関数は何も行いません。@n
                NN_DETAIL_NEWS_SYSTEM_STORAGE_MOUNT_ALWAYS は nn/news/detail/service/core/news_FileSystemConfig.h で定義されます。
*/
void UnmountSystemStorage() NN_NOEXCEPT;

/*!
    @brief      ローカルニュースを投稿します。

    @param[in]  path    ファイルパス。

    @pre
        - path != nullptr

    @details
                マウント名は "rom" を使用するため、指定するパスは "rom:/" ではじめてください。
*/
nn::Result PostLocalNews(const char* path) NN_NOEXCEPT;

}}
