#!/bin/bash

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
cd $DIR

cd ../..

if [ "$NNTEST_ENABLE_CRL_TEST" != "true" ]
then
    echo "**"
    echo "** Warning ** The CRL tests will NOT be ran. Please set NNTEST_ENABLE_CRL_TEST to true and rebuild SSL process and tests."
    echo "**"
    sleep 5
fi

nact specs=Generic platforms=Win32_VS2015 -d Tests/Net
RESULT=$?

if [ $RESULT != 0 ]
then
   echo
   echo " * Building Tests/Net failed with error: " $RESULT
   exit $RESULT
fi

nact specs=NX platforms=NXFP2-a32,NXFP2-a64 -d Tests/Net
RESULT=$?

if [ $RESULT != 0 ]
then
   echo
   echo " * Building Tests/Net failed with error: " $RESULT
   exit $RESULT
fi

if ! [ -f Programs/Eris/Outputs/Win32-v140/TargetTools/SettingsManager/Develop/SettingsManager.exe ]
then
    echo " * Building Win32 Programs/Eris/Sources/TargetTools"

    nact specs=Generic platforms=Win32_VS2015 -d Programs/Eris/Sources/TargetTools
    RESULT=$?

    if [ $RESULT != 0 ]
    then
       echo
       echo " * Building Win32 Programs/Eris/Sources/TargetTools failed with error: " $RESULT
       exit $RESULT
    fi
else
    echo " * Skipping Win32 Programs/Eris/Sources/TargetTools"
fi

if ! [ -f Programs/Eris/Outputs/NX-NXFP2-a32/TargetTools/SettingsManager/Develop/SettingsManager.nca ]
then
    echo " * Building NX-NXFP2-a32,NX-NXFP2-a64 Programs/Eris/Sources/TargetTools"

    nact specs=NX platforms=NXFP2-a32,NXFP2-a64 -d Programs/Eris/Sources/TargetTools
    RESULT=$?

    if [ $RESULT != 0 ]
    then
       echo
       echo " * Building Programs/Eris/Sources/TargetTools failed with error: " $RESULT
       exit $RESULT
    fi
else
 echo " * Skipping NX-NXFP2-a32,NX-NXFP2-a64 Programs/Eris/Sources/TargetTools"
fi

exit 0
