﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NetTest/Horizon/NetTest_Types.h"
#include "NetTest/Horizon/NetTest_OS.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

#include <cstring>
#include <cstdio>

#include <windows.h>

namespace
{
    static const uint32_t FileNameBufLen = 128;
    static const uint32_t KbSize = 1024;
}


TEST(natf, GenTestFile)
{
    int argC = 0;
    const char * const * pArgV = nullptr;
    uint32_t fileSizeBytes = 0;
    int32_t fileSizeKb = 0;
    int32_t fileSizeMb = 0;
    const int32_t invalidSize = -1;
    char pFileName[FileNameBufLen] = {0};
    NATF::Utils::ParserGroup parser;

    NETTEST_GET_ARGS(argC, pArgV);

    parser.AddParser(NATF::Utils::StringParser ("--FileName", nullptr, pFileName, sizeof(pFileName)));
    parser.AddParser(NATF::Utils::Int32Parser  ("--FileSizeKb", &invalidSize, fileSizeKb));
    parser.AddParser(NATF::Utils::Int32Parser  ("--FileSizeMb", &invalidSize, fileSizeMb));

    if (!parser.Parse(argC, pArgV))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        FAIL();
        return;
    }

    if(fileSizeKb > 0)
    {
        fileSizeBytes = (uint32_t)fileSizeKb * 1024;
    }
    else if(fileSizeMb > 0)
    {
        fileSizeBytes = (uint32_t)fileSizeMb * 1024 * 1024;
    }
    else
    {
        NN_NETTEST_LOG(" * ERROR: Either --FileSizeKb or --FileSizeMb must be specified!\n\n");
        FAIL();
        return;
    }

    FILE* pWriteFile = fopen(pFileName, "wb");
    if( !pWriteFile )
    {
        NN_NETTEST_LOG("Failed to open file for writing!\nFileName: %s\n\n", pFileName);
        FAIL();
    }

    uint32_t kbChunkCount = fileSizeBytes / KbSize;
    for(uint32_t iKbChunk = 0; iKbChunk < kbChunkCount; ++iKbChunk)
    {
        char pBuffer[KbSize];
        uint32_t pos = iKbChunk * KbSize;

        char val = static_cast<char>(pos);
        for(uint32_t iByte = 0; iByte < KbSize; ++iByte)
        {
            pBuffer[iByte] = val;
            ++val;
        }

        size_t bytesWritten = fwrite(pBuffer, 1, KbSize, pWriteFile);
        if( bytesWritten != KbSize )
        {
            NN_NETTEST_LOG("File error while writing! err: %d\n\n", ferror(pWriteFile));
            FAIL();
            break;
        }
    }

    fclose(pWriteFile);

    NN_NETTEST_LOG("Exiting...\n");
}
