﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NetTest/Horizon/NetTest_Types.h"
#include "NetTest/Horizon/NetTest_OS.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

#include <cstring>
#include <cstdio>

#include <windows.h>

namespace
{
    const uint32_t ReadBufLen  = 1024;
    const uint32_t MaxFilePath = 2048;

    const char * const DownloadPath = "${DOWNLOAD_PATH}";
}

TEST(natf, GenDnsNetworkSettings)
{
    int argC = 0;
    const char * const * pArgV = nullptr;
    char pConfigFileIn[MaxFilePath];
    char pConfigFileOut[MaxFilePath];
    char pDownloadPath[MaxFilePath];
    NATF::Utils::ParserGroup parser;

    NETTEST_GET_ARGS(argC, pArgV);

    parser.AddParser(NATF::Utils::StringParser ("--DownloadPath", nullptr, pDownloadPath, sizeof(pDownloadPath)));
    parser.AddParser(NATF::Utils::StringParser ("--ConfigFileIn", nullptr, pConfigFileIn, sizeof(pConfigFileIn)));
    parser.AddParser(NATF::Utils::StringParser ("--ConfigFileOut", nullptr, pConfigFileOut, sizeof(pConfigFileOut)));

    if (!parser.Parse(argC, pArgV))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        FAIL();
        return;
    }

    // Convert to upper-case to avoid '\t' turning into tabs.
    NetTest::StrUpr(pDownloadPath);

    FILE* pReadFile = fopen(pConfigFileIn, "rt");
    if( !pReadFile )
    {
        NN_NETTEST_LOG("Failed to open file!\n\n");
        FAIL();
    }

    FILE* pWriteFile = fopen(pConfigFileOut, "wt");
    if( !pWriteFile )
    {
        fclose(pReadFile);
        NN_NETTEST_LOG("Failed to open file!\n\n");
        FAIL();
    }

    while(!feof(pReadFile))
    {
        char pBuffer[ReadBufLen];
        char* pRet = fgets(pBuffer, ReadBufLen, pReadFile);
        if( pRet )
        {
            char* pFindDownloadPathVar = strstr(pBuffer, DownloadPath);

            if( pFindDownloadPathVar )
            {
                NN_NETTEST_LOG("Found %s\n", pFindDownloadPathVar);
                int writtenBytes = NETTEST_SNPRINTF(pFindDownloadPathVar, ReadBufLen - (pFindDownloadPathVar - pBuffer), "%s;\n", pDownloadPath);
                if( writtenBytes != (int)strlen(pFindDownloadPathVar) )
                {
                    NN_NETTEST_LOG("Failed to write to buffer! BufLen: %d, Bytes to write: %d\n\n", ReadBufLen, writtenBytes);
                    FAIL();
                    break;
                }
            }

            size_t lineLen = strlen(pBuffer);
            size_t bytesWritten = fwrite(pBuffer, 1, lineLen, pWriteFile);
            if( bytesWritten != lineLen )
            {
                NN_NETTEST_LOG("File error while writing! err: %d\n\n", ferror(pReadFile));
                FAIL();
                break;
            }
        }
        else if( ferror(pReadFile) )
        {
            NN_NETTEST_LOG("File error while reading! err: %d\n\n", ferror(pReadFile));
            FAIL();
            break;
        }
    }

    fclose(pReadFile);
    fclose(pWriteFile);

    NN_NETTEST_LOG("Exiting...\n");
}
