﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Tests/SoHttpDownloadMultiTest.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

namespace
{
    const uint32_t WaitTypeBufLen = 16;
}

// SoHttpDownload
TEST(natf, SoHttpDownloadMulti)
{
    bool isSuccess;
    NATF::Utils::ParserGroup parser;
    int argc;
    uint16_t defaultPortNum = 80;
    uint16_t portNum = 0;
    uint32_t timeoutMs = 0;
    MD5Hash::Result expectedHash;
    bool useSelect = true;
    char pWaitType[WaitTypeBufLen];
    const char* pDefaultWaitType = "Select";
    const char * const * pArgv;
    bool defaultDoNnLinger = true;
    bool doNnLinger = defaultDoNnLinger;

    uint32_t connectionCount;
    nn::util::Uuid netProfile;
    char pIp[NATF::Tests::SoHttpDownloadMulti::MaxIpNameLen];
    char pResource[NATF::Tests::SoHttpDownloadMulti::MaxResourceLen];
    char pTestName[NATF::BaseTest::NameBufferLen];

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argc, pArgv);

    parser.AddParser(NATF::Utils::StringParser  ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UInt32Parser  ("--ConnectionCount", nullptr, connectionCount));
    parser.AddParser(NATF::Utils::UuidParser    ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::StringParser  ("--IpAddr", nullptr, pIp, sizeof(pIp)));
    parser.AddParser(NATF::Utils::StringParser  ("--Resource", nullptr, pResource, sizeof(pResource)));
    parser.AddParser(NATF::Utils::UInt16Parser  ("--PortNum", &defaultPortNum, portNum));
    parser.AddParser(NATF::Utils::UInt32Parser  ("--TimeoutMs", nullptr, timeoutMs));
    parser.AddParser(NATF::Utils::Md5HashParser ("--Md5Hash", nullptr, expectedHash));
    parser.AddParser(NATF::Utils::StringParser  ("--WaitType", pDefaultWaitType, pWaitType, sizeof(pWaitType)));
    parser.AddParser(NATF::Utils::BoolParser    ("--NnLinger", &defaultDoNnLinger, doNnLinger));

    if( !parser.Parse(argc, pArgv) )
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    NetTest::StrUpr(pWaitType);
    if( strncmp(pWaitType, "SELECT", WaitTypeBufLen) == 0 )
    {
        useSelect = true;
    }
    else if( strncmp(pWaitType, "POLL", WaitTypeBufLen) == 0 )
    {
        useSelect = false;
    }
    else
    {
        NN_NETTEST_LOG(" Failed to parse --WaitType. Valid inputs: Select, Poll\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    NATF::Tests::SoHttpDownloadMulti soHttpDownloadMulti(pTestName, netProfile, timeoutMs, connectionCount, pIp, portNum, pResource, expectedHash, useSelect, true, doNnLinger);

    isSuccess = soHttpDownloadMulti.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
