﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Port/Port.h"

namespace nnt { namespace net { namespace p2p {

class Params;

class Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT = 0;
    virtual const char* GetName() const NN_NOEXCEPT = 0;

    static const Parser* const g_pParsers[];
    static const uint32_t ParserCount;

protected:
    bool ParseInt(int& intOut, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT;
    bool ParseFloat(float& fltOut, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT;
};

class NodeIndexParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--NODE_INDEX"; }
};

class PacketSizeParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--PACKET_SIZE"; }
};

class PacketCountParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--PACKET_COUNT"; }
};

class FrameIntParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--FRAME_INT"; }
};

class ReportIntParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--REPORT_INT"; }
};

class TestDurationParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--TEST_DURATION"; }
};

class AddrInfoParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--NODES_ADDR_INFO"; }
};

class VerifyDataParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--VERIFY_DATA"; }
};

class CallTimeParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--REPORT_CALLTIME"; }
};

class TermBadDataParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--TERM_BAD_DATA"; }
};

class ReportNodeStatsParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--REPORT_NODE_STATS"; }
};

class ReportCsvParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--REPORT_CSV"; }
};

class NoReportParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--NO_REPORT"; }
};

class RttFrameIntParser : public Parser
{
public:
    virtual bool Parse(Params& param, int argC, const char * const * argV, unsigned iArg) const NN_NOEXCEPT NN_OVERRIDE;

    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE
    { return "--RTT_FRAME_INT"; }
};

}}} // Namespaces
