﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

#include <nn/nifm.h>

#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/os.h>
#include <nn/socket.h>

extern "C"
{
int        testMain(int argc, char **argv);

const int  MemoryPoolSize = 10 * 1024 * 1024;
uint8_t    NN_ALIGNAS(4096) mempool[MemoryPoolSize];
size_t     mempoolSize = MemoryPoolSize;
int        SocketAllocatorSize = 128 * 1024;
int        Count = 14;
}

extern "C" void nnMain()
{
    nn::nifm::Initialize();

    nn::nifm::SubmitNetworkRequestAndWait();

    if( nn::nifm::IsNetworkAvailable() )
    {
        NN_LOG("Network is available.\n");

        nn::socket::Initialize( mempool, MemoryPoolSize, SocketAllocatorSize, Count );

        int    argC;
        char** argV;

        //const  char* defaultArguments[] = { "iperf", "-c", "192.168.0.10", "-i", "1" };
        //argV = const_cast<char**>(defaultArguments);
        //argC = sizeof(defaultArguments) / sizeof(defaultArguments[0]);

        argC = nn::os::GetHostArgc();
        argV = nn::os::GetHostArgv();
        strcpy(argV[0], "iperf\0");

        for (int i = 0; i < argC; i++)
        {
            NN_LOG("%s ", argV[i]);
        }

        NN_LOG("\n");

        testMain(argC, argV);
    }
    else
    {
        NN_LOG("Network is not available.\n");
    }
    nn::nifm::CancelNetworkRequest();
    NN_ASSERT(!nn::nifm::IsNetworkAvailable());
}
