﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#include <nn/socket.h>
#include <nn/socket/socket_ApiPrivate.h>
#include <nn/nn_Log.h>
#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#define NN_NETWORK_INTERFACE_NAME "usb0"

namespace
{
    bool TestIoctl_NoPerms(nn::socket::IoctlCommand command, void * pData, int dataSize)
    {
        int sock = -1;
        if ((sock = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp)) == -1)
        {
            return false;
        }

        int res = nn::socket::Ioctl(sock, command, pData, dataSize);
        if (res == -1 && nn::socket::GetLastError() == nn::socket::Errno::EPerm)
        {
            nn::socket::Close(sock);
            return true;
        }
        nn::socket::Close(sock);
        return false;
    }

    bool TestIoctl_NoPerms(nn::socket::IoctlCommandPrivate command, void * pData, int dataSize)
    {
        int sock = -1;
        if ((sock = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp)) == -1)
        {
            return false;
        }

        int res = nn::socket::Ioctl(sock, command, pData, dataSize);
        if (res == -1 && nn::socket::GetLastError() == nn::socket::Errno::EPerm)
        {
            nn::socket::Close(sock);
            return true;
        }
        nn::socket::Close(sock);
        return false;
    }

    bool TestIoctlIfreq_NoPerms(nn::socket::IoctlCommand command)
    {
        struct ifreq req;
        memset(&req, 0, sizeof(req));
        strncpy((char*)req.ifr_name, NN_NETWORK_INTERFACE_NAME, nn::socket::IfNamSiz);
        req.ifr_addr.sa_family = static_cast<int>(nn::socket::Family::Af_Inet);

        return TestIoctl_NoPerms(command, &req, sizeof(req));
    }

    bool TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate command)
    {
        struct ifreq req;
        memset(&req, 0, sizeof(req));
        strncpy((char*)req.ifr_name, NN_NETWORK_INTERFACE_NAME, nn::socket::IfNamSiz);
        req.ifr_addr.sa_family = static_cast<int>(nn::socket::Family::Af_Inet);

        return TestIoctl_NoPerms(command, &req, sizeof(req));
    }

    bool TestOpen_NoPerms(const char * path)
    {
        int fd = 0;
        if ((fd = nn::socket::Open(path, nn::socket::OpenFlag::O_RdWr)) == -1)
        {
            if (nn::socket::GetLastError() == nn::socket::Errno::EPerm)
            {
                return true;
            }
        }
        else
        {
            nn::socket::Close(fd);
        }
        return false;
    }

    bool TestSocketPorts_NoPerms()
    {
        int sock = 0;
        nn::socket::SockAddrIn sockAddr;
        if ((sock = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp)) != -1)
        {
            for (int i = 1; i < 1024; ++i)
            {
                memset(&sockAddr, 0, sizeof(nn::socket::SockAddrIn));
                sockAddr.sin_family = nn::socket::Family::Af_Inet;
                sockAddr.sin_port = nn::socket::InetHtons(i);
                sockAddr.sin_addr.S_addr = nn::socket::InetHtonl(nn::socket::InAddr_Any);

                int ret = nn::socket::Bind(sock, (nn::socket::SockAddr *)&sockAddr, sizeof(nn::socket::SockAddr));
                if (ret < 0)
                {
                    if (nn::socket::GetLastError() != nn::socket::Errno::EAcces)
                    {
                        nn::socket::Close(sock);
                        return false;
                    }
                }
                else
                {
                    nn::socket::Close(sock);
                    return false;
                }
            }
            nn::socket::Close(sock);
        }

        return true;
    }

    bool TestSocket_NoPerms(nn::socket::Family domain, nn::socket::Type type, nn::socket::Protocol protocol)
    {
        int sock = 0;
        if ((sock = nn::socket::Socket(domain, type, protocol)) == -1)
        {
            if (nn::socket::GetLastError() == nn::socket::Errno::EPerm)
            {
                return true;
            }
        }
        else
        {
            nn::socket::Close(sock);
        }
        return false;
    }

    bool TestSetSockOpt_NoPerms(nn::socket::Level level, nn::socket::Option optionName, const void* pOptionValue, nn::socket::SockLenT optionLength, bool useEcho = false)
    {
       bool ret = false;
       int sock;
       if (useEcho)
       {
           sock = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Raw, nn::socket::Protocol::IpProto_Icmp);
       }
       else
       {
           sock = nn::socket::Socket(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Stream, nn::socket::Protocol::IpProto_Tcp);
       }
       if (sock == -1)
       {
           return ret;
       }


       if (nn::socket::SetSockOpt(sock, level, optionName, pOptionValue, optionLength) == -1)
       {
           if (nn::socket::GetLastError() == nn::socket::Errno::EPerm)
           {
               ret = true;
           }
       }
       nn::socket::Close(sock);
       return ret;
    }

    bool TestDuplicateSocket_NoPerms()
    {

        int fd = 0;
        if ((fd = nn::socket::DuplicateSocket(0, 0)) == -1)
        {
            if (nn::socket::GetLastError() == nn::socket::Errno::EPerm)
            {
                return true;
            }
        }
        else
        {
            nn::socket::Close(fd);
        }
        return false;

    }

    bool TestPermissions_Main()
    {
        bool isSuccess = true;
        bool rval = false;
        int var = 1;

        nn::socket::IfReq ibuf[16];
        nn::socket::IfConf ifc;
        nn::socket::IfMediaReq ifmr;
        nn::socket::IfAliasReq ifra;
        nn::socket::SockAddrIn * sa = nullptr;
        // open bpf permission test
        PRINT_AND_CALL(rval = TestOpen_NoPerms("/dev/bpf"));
        ERROR_IF_AND_COUNT(rval != true, "TestOpen_NoPerms(\"/dev/bpf\") test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestOpen_NoPerms("/dev/bpf0"));
        ERROR_IF_AND_COUNT(rval != true, "TestOpen_NoPerms(\"/dev/bpf0\") test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);


        // reserved port range test
        PRINT_AND_CALL(rval = TestSocketPorts_NoPerms());
        ERROR_IF_AND_COUNT(rval != true, "TestSocketPorts_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // Duplicate Socket test
        PRINT_AND_CALL(rval = TestDuplicateSocket_NoPerms());
        ERROR_IF_AND_COUNT(rval != true, "nn::socket::DuplicateSocket() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // Socket permission tests
        PRINT_AND_CALL(rval = TestSocket_NoPerms(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Raw, nn::socket::Protocol::IpProto_Icmp));
        ERROR_IF_AND_COUNT(rval != false, "TestSocket_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSocket_NoPerms(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_Raw, nn::socket::Protocol::IpProto_Ip));
        ERROR_IF_AND_COUNT(rval != true, "TestSocket_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSocket_NoPerms(nn::socket::Family::Af_Route, nn::socket::Type::Sock_Raw, nn::socket::Protocol::IpProto_Ip));
        ERROR_IF_AND_COUNT(rval != true, "TestSocket_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSocket_NoPerms(nn::socket::Family::Af_Link, nn::socket::Type::Sock_Raw, nn::socket::Protocol::IpProto_Ip));
        ERROR_IF_AND_COUNT(rval != true, "TestSocket_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSocket_NoPerms(nn::socket::Family::Af_Inet, nn::socket::Type::Sock_SeqPacket, nn::socket::Protocol::IpProto_Ip));
        ERROR_IF_AND_COUNT(rval != true, "TestSocket_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // Socket option (nn::socket::Level::Sol_Socket) permission tests

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Socket, nn::socket::Option::So_Debug, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Socket, nn::socket::Option::So_SetFib, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Socket, nn::socket::Option::So_Label, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Socket, nn::socket::Option::So_PeerLabel, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Socket, nn::socket::Option::So_User_Cookie, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // Ip option (nn::socket::Protocol::IpProto_Ip) permission tests

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Multicast_If, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != false, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Multicast_Ttl, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != false, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Multicast_Loop, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != false, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Add_Membership, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != false, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Drop_Membership, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != false, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Multicast_Vif, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != false, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Rsvp_On, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Rsvp_Off, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Rsvp_Vif_On, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Rsvp_Vif_Off, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_Faith, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_HdrIncl, &var, sizeof(var), true));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Ip, nn::socket::Option::Ip_PortRange, &var, sizeof(var), true));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // Ip option (nn::socket::Protocol::IpProto_Tcp) permission test

        PRINT_AND_CALL(rval = TestSetSockOpt_NoPerms(nn::socket::Level::Sol_Tcp, nn::socket::Option::Tcp_Md5Sig, &var, sizeof(var)));
        ERROR_IF_AND_COUNT(rval != true, "TestSetSockOpt_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // (nn::socket::IoctlCommand::FionRead) permission tests

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommand::FionRead));
        ERROR_IF_AND_COUNT(rval != false, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommand::FionWrite));
        ERROR_IF_AND_COUNT(rval != false, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommand::FionSpace));
        ERROR_IF_AND_COUNT(rval != false, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        // Ioctl SIOC (Low Level IO) options permission tests

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfIndex));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocSIfLlAddr));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocDIfAddr));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocSIfFlags));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfAddr));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfNetmask));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfDupInfo));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocSIfMtu));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfMtu));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfMetric));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocSIfMetric));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

        PRINT_AND_CALL(rval = TestIoctlIfreq_NoPerms(nn::socket::IoctlCommandPrivate::SiocAtMark));
        ERROR_IF_AND_COUNT(rval != false, "TestIoctlIfreq_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);


        ifc.ifc_len = sizeof(ibuf);
        ifc.ifc_buf = (caddr_t)ibuf;

        PRINT_AND_CALL(rval = TestIoctl_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfConf, &ifc, sizeof(ifc)));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctl_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);


        memset(&ifmr, 0, sizeof(ifmr));
        strncpy(ifmr.ifm_name, NN_NETWORK_INTERFACE_NAME, nn::socket::IfNamSiz);

        PRINT_AND_CALL(rval = TestIoctl_NoPerms(nn::socket::IoctlCommandPrivate::SiocGIfMedia, &ifmr, sizeof(ifmr)));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctl_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);


        memset(&ifra, 0, sizeof(ifra));
        strncpy(ifra.ifra_name, NN_NETWORK_INTERFACE_NAME, nn::socket::IfNamSiz);



        sa = (nn::socket::SockAddrIn *)(void *)&ifra.ifra_addr;
        sa->sin_family = nn::socket::Family::Af_Inet;
        sa->sin_len = sizeof(*sa);
        sa->sin_addr.S_addr = nn::socket::InetHtonl(nn::socket::InAddr_Any);

        sa = (nn::socket::SockAddrIn *)(void *)&ifra.ifra_mask;
        sa->sin_family = nn::socket::Family::Af_Inet;
        sa->sin_len = sizeof(*sa);
        sa->sin_addr.S_addr = nn::socket::InetHtonl(nn::socket::InAddr_Any);

        PRINT_AND_CALL(rval = TestIoctl_NoPerms(nn::socket::IoctlCommandPrivate::SiocAIfAddr, &ifra, sizeof(ifra)));
        ERROR_IF_AND_COUNT(rval != true, "TestIoctl_NoPerms() test failed");
        nn::socket::SetLastError(nn::socket::Errno::ESuccess);

out:
        return isSuccess;
    }//NOLINT(impl/function_size)

}

namespace NATF {
namespace API {

TEST(ApiUnit, TestPermissions_Setup)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Socket | NATF::API::TestSetupOptions_Nifm), "TestSetup failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestPermissions_Main)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    INITIALIZE_TEST_COUNTS;

    NN_LOG("Calling TestPermissions_Main...\n");
    isSuccess = ::TestPermissions_Main();

    PRINT_TEST_COUNTS;

    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestPermissions_Teardown)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

}} // NATF::API
