﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#include <nn/socket.h>
#include <nn/nn_Log.h>

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

namespace
{
    bool TestInetHtons_HostShort(uint16_t hostAddr, bool isSupported)
    {
        bool isSuccess = true;
        uint16_t rval;

        PRINT_AND_CALL(rval = nn::socket::InetHtons(hostAddr));

        if( isSupported )
        {
            ERROR_IF(!NATF::API::VerifyHostNetAddrEquiv(hostAddr, rval), "InetHtons failed when expected to succeed.");
        }
        else
        {
            ERROR_IF(NATF::API::VerifyHostNetAddrEquiv(hostAddr, rval), "InetHtons succeeded when expected to fail.");
        }

out:
        return isSuccess;
    }

    bool TestInetHtons_Main()
    {
        bool isSuccess = true;
        bool rval = false;

        ////////////////////////////////////////////////////////////////
        // Function:
        // uint16_t htons(uint16_t hostshort);

        ////////////////////////////////////////////////////////////////
        // Argument:
        // uint16_t hostshort

        PRINT_AND_CALL(rval = TestInetHtons_HostShort(0x0000, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtons() test failed");

        PRINT_AND_CALL(rval = TestInetHtons_HostShort(0xFF00, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtons() test failed");

        PRINT_AND_CALL(rval = TestInetHtons_HostShort(0x00FF, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtons() test failed");

        PRINT_AND_CALL(rval = TestInetHtons_HostShort(0xFFFF, true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtons() test failed");

        PRINT_AND_CALL(rval = TestInetHtons_HostShort(static_cast<uint16_t>(-1), true));
        ERROR_IF_AND_COUNT(rval != true, "InetHtons() test failed");

out:
        return isSuccess;
    }

} // unnamed

namespace NATF {
namespace API {

TEST(ApiUnit, TestInetHtons_Setup)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Socket), "TestSetup failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestInetHtons_Main)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    INITIALIZE_TEST_COUNTS;

    NN_LOG("Calling TestInetHtons_Main...\n");
    isSuccess = ::TestInetHtons_Main();

    PRINT_TEST_COUNTS;

    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit, TestInetHtons_Teardown)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

}} // NATF::API
