﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#include <nn/socket.h>
#include <nn/nn_Log.h>

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

namespace
{
    bool Win_InetAton_AddrAscii(const char *src, bool isSupported)
    {
        bool isSuccess = true;
        int rval = -1;

        nn::socket::SockAddrIn addr;

        memset(&addr, 0, sizeof(addr));
        PRINT_AND_CALL(rval = nn::socket::InetAton(src, &addr.sin_addr));

        if( isSupported )
        {
            ERROR_IF(rval == 0, "InetAton failed when expected to succeed.");
            ERROR_IF(!NATF::API::VerifyIpAddrEquiv(src, &addr.sin_addr), "VerifyIpAddrEquiv failed.");
        }
        else
        {
            ERROR_IF(rval != 0, "InetAton succeeded when expected to fail.");
        }

out:
        return isSuccess;
    }

    bool Win_InetAton_AddrNetwork(void *pAddrNetwork, bool isSupported)
    {
        bool isSuccess = true;
        int rval = -1;

        PRINT_AND_CALL(rval = nn::socket::InetAton("127.0.0.1", reinterpret_cast<nn::socket::InAddr *>(pAddrNetwork)));

        if( isSupported )
        {
            ERROR_IF(rval == 0, "InetAton failed when expected to succeed.");
            ERROR_IF(!NATF::API::VerifyIpAddrEquiv("127.0.0.1", reinterpret_cast<nn::socket::InAddr *>(pAddrNetwork)), "VerifyIpAddrEquiv failed.");
        }
        else
        {
            ERROR_IF(rval != 0, "InetAton succeeded when expected to fail.");
        }

out:
        return isSuccess;
    }

    bool Win_InetAton_Main()
    {
        bool isSuccess = true;
        bool rval = false;

        const char ASCII_SPACE = 0x20;

        char srcNoTerminatingNull[256];
        nn::socket::SockAddrIn addrIpv4;
        char alternateAddrNetwork[4];

        ////////////////////////////////////////////////////////////////
        // Function:
        // int inet_aton(const char *cp, nn::socket::InAddr *inp);

        ////////////////////////////////////////////////////////////////
        // Argument:
        // const char *cp

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii(nullptr, false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        memset(srcNoTerminatingNull, ASCII_SPACE, 256);
        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii(srcNoTerminatingNull, false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("127.0.0.1", true));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("127.0.0.1/24", false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("127.0.0.1/128", false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("::1", false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("255.255.255.255", true));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("0.0.0.0", true));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("ABCDEFGHIJK", false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("10000000000", false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrAscii("1000.1000.1000.1000", false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        ////////////////////////////////////////////////////////////////
        // Argument:
        // nn::socket::InAddr *inp

        PRINT_AND_CALL(rval = Win_InetAton_AddrNetwork(&addrIpv4.sin_addr, true));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

#ifdef sockaddr_in6
{
        // NOTE: sockaddr_in6 not defined
        struct sockaddr_in6 addrIpv6;
        PRINT_AND_CALL(rval = Win_InetAton_AddrNetwork(&addrIpv6.sin6_addr, false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");
}
#endif

        PRINT_AND_CALL(rval = Win_InetAton_AddrNetwork(nullptr, false));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

        PRINT_AND_CALL(rval = Win_InetAton_AddrNetwork(reinterpret_cast<void*>(alternateAddrNetwork), true));
        ERROR_IF_AND_COUNT(rval != true, "InetAton() test failed");

out:
        return isSuccess;
    }

} // unnamed

namespace NATF {
namespace API {

TEST(ApiUnit,Win_InetAton_Setup)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Socket), "TestSetup failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit,Win_InetAton_Main)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    INITIALIZE_TEST_COUNTS;

    NN_LOG("Calling Win_InetAton_Main...\n");
    isSuccess = ::Win_InetAton_Main();

    PRINT_TEST_COUNTS;

    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

TEST(ApiUnit,Win_InetAton_Teardown)
{
    bool isSuccess = true;
    NN_LOG("In\n\n");

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed");

out:
    EXPECT_EQ(isSuccess, true);
    NN_LOG("Out\n\n");
}

}} // NATF::API
