﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Tests/SslAbuseTest.h"
#include <nn/ssl.h>
#include <nn/nifm.h>
#include <nn/fs.h>

#include <new> // For placement new
#include <cstring>
#include <cstdlib> // For Malloc

namespace NATF {
namespace Tests {

    // Constructor
    SslAbuse::SslAbuse(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, const char* pHostName, uint16_t portNum, const char* pServerCertPath) NN_NOEXCEPT
        : BaseTest(pTestName, false, Utils::InitApiFlags::InitApiFlags_Nifm | Utils::InitApiFlags::InitApiFlags_Network | Utils::InitApiFlags::InitApiFlags_Socket | Utils::InitApiFlags::InitApiFlags_Ssl, netProfile),
          m_pModule(nullptr),
          m_portNum(portNum),
          m_timeoutMs(timeoutMs)
    {
        if( pHostName )
        {
            NETTEST_SNPRINTF(m_pHostName, sizeof(m_pHostName), "%s", pHostName);
        }
        else
        {
            m_pHostName[0] = '\0';
        }

        if( pServerCertPath )
        {
            NETTEST_SNPRINTF(m_pServerCertPath, sizeof(m_pServerCertPath), "%s", pServerCertPath);
        }
        else
        {
            m_pServerCertPath[0] = '\0';
        }
    }

    // Destructor
    SslAbuse::~SslAbuse() NN_NOEXCEPT
    {
        FreeModules();
    }

    // Init
    bool SslAbuse::Init() NN_NOEXCEPT
    {
        nn::Result result = nn::fs::MountHostRoot();
        if( result.IsFailure() )
        {
            Log(" * Warning: Failed to mount host file system!\n\n");
        }

        return true;
    }

    // Cleanup
    bool SslAbuse::Cleanup() NN_NOEXCEPT
    {
        FreeModules();
        nn::fs::UnmountHostRoot();

        return true;
    }

    // Config
    bool SslAbuse::Config() NN_NOEXCEPT
    {
        if( !AllocateModules() )
        {
            return false;
        }

        TestThread* pServerThread = CreateTestThread("Thread", m_timeoutMs);
        if( !pServerThread )
        {
            return false;
        }

        pServerThread->AddModule(*m_pModule);

        return true;
    }

    // AllocateModules
    bool SslAbuse::AllocateModules() NN_NOEXCEPT
    {
        // Allocate Server modules
        m_pModule = new Modules::SslAbuse(m_pHostName, m_portNum, m_pServerCertPath);
        if( !m_pModule )
        {
            Log(" Failed to allocate memory!\n\n");
            FreeModules();
            return false;
        }

        return true;
    }

    // FreeModules
    void SslAbuse::FreeModules() NN_NOEXCEPT
    {
        if( m_pModule )
        {
            delete m_pModule;
            m_pModule = nullptr;
        }
    }

} // namespace Tests
} // namespace NATF
