﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Tests/HttpServerTest_Win.h"

namespace
{
    const uint32_t ExtraTimeSec = 5;
}

namespace NATF {
namespace Tests {

    // Constructor
    HttpServer::HttpServer(const char* pTestName, bool useSsl, uint32_t durationSec, uint16_t portNum, uint32_t cpuFreqMs, bool authClient, bool quitOnError) NN_NOEXCEPT :
        BaseTest(pTestName, false, Utils::InitApiFlags::InitApiFlags_Nifm | Utils::InitApiFlags::InitApiFlags_Network | Utils::InitApiFlags::InitApiFlags_Socket),
        m_durationSec(durationSec),
        m_portNum(portNum),
        m_cpuFreqMs(cpuFreqMs),
        m_useSsl(useSsl),
        m_authClient(authClient),
        m_quitOnError(quitOnError),
        m_pHttpServer(nullptr),
        m_pCpuUsage(nullptr)
    { }

    // Destructor
    HttpServer::~HttpServer() NN_NOEXCEPT {}

    // Cleanup
    bool HttpServer::Cleanup() NN_NOEXCEPT
    {
        if( nullptr != m_pHttpServer )
        {
            delete m_pHttpServer;
            m_pHttpServer = nullptr;
        }

        if( nullptr != m_pCpuUsage )
        {
            delete m_pCpuUsage;
            m_pCpuUsage = nullptr;
        }

        return true;
    }

    // Config
    bool HttpServer::Config() NN_NOEXCEPT
    {
        Log("Allocating module...\n");
        m_pHttpServer = new Modules::HttpServer(m_portNum, m_durationSec, m_useSsl, m_authClient, m_quitOnError);
        if( nullptr == m_pHttpServer )
        {
            LogError(" * Failed to allocate HttpServer module!\n\n");
            return false;
        }

        if( m_cpuFreqMs > 0 )
        {
            m_pCpuUsage = new Modules::CpuUsage(m_cpuFreqMs);
            if( nullptr == m_pCpuUsage )
            {
                LogError(" * Failed to allocate CpuUsage module!\n\n");
                delete m_pHttpServer;
                m_pHttpServer = nullptr;

                return false;
            }

            Log("Creating slave thread...\n");
            bool isSuccess = AddSlaveModule("Cpu", *m_pCpuUsage);
            if( !isSuccess )
            {
                delete m_pHttpServer;
                delete m_pCpuUsage;
                m_pHttpServer = nullptr;
                m_pCpuUsage = nullptr;

                return false;
            }
        }

        Log("Creating test thread...\n");
        TestThread* pThread1 = CreateTestThread("Server", m_durationSec + ExtraTimeSec);
        if( !pThread1 )
        {
            delete m_pHttpServer;
            delete m_pCpuUsage;
            m_pHttpServer = nullptr;
            m_pCpuUsage = nullptr;

            return false;
        }

        Log("Adding module...");
        pThread1->AddModule(*m_pHttpServer);

        return true;
    }

} // namespace Tests
} // namespace NATF
