﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Modules/IperfModule.h"
#include "NetTest_Port.h"
#include "iperf_lib.h"

namespace NATF {
namespace Modules {

    // Constructor
    Iperf::Iperf(int argC, char** pArgV) NN_NOEXCEPT :
        BaseModule(true),
        m_argC(argC),
        m_pArgV(pArgV) {}

    // Run
    bool Iperf::Run() NN_NOEXCEPT
    {
        int rval = nnt::net::Iperf(m_argC, m_pArgV);
        if( 0 != rval )
        {
            LogError("Iperf failure! rval: %d\n\n", rval);
        }

        return rval == 0;
    }

    // GetName
    const char* Iperf::GetName() const NN_NOEXCEPT
    { return "Iperf"; }

}} // namespace NATF::Modules
