﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Modules/CpuUsageModule_Win.h"

#ifndef NN_BUILD_CONFIG_OS_WIN32
    #error "This is only supported by Win32"
#else

namespace NATF {
namespace Modules {

CpuUsage::CpuUsage(uint32_t printFreqMs) NN_NOEXCEPT
:   m_doShutdown(false),
    m_printFreqMs(printFreqMs)
{
    PdhOpenQuery(nullptr, 0, &m_cpuQuery);
    PdhAddCounter(m_cpuQuery, L"\\Processor(_Total)\\% Processor Time", 0, &m_cpuTotal);
    PdhCollectQueryData(m_cpuQuery);
}

CpuUsage::~CpuUsage() NN_NOEXCEPT
{}

double CpuUsage::GetCurrentUsage() const NN_NOEXCEPT
{
    PDH_FMT_COUNTERVALUE counterVal;

    PdhCollectQueryData(m_cpuQuery);
    PdhGetFormattedCounterValue(m_cpuTotal, PDH_FMT_DOUBLE, nullptr, &counterVal);
    return counterVal.doubleValue;
}

void CpuUsage::StopSlave() NN_NOEXCEPT
{
    m_doShutdown = true;
}

// Run
bool CpuUsage::Run() NN_NOEXCEPT
{
    Log("Started!\n");

    do
    {
        double cpu = GetCurrentUsage();
        int cpuInt = (int)(cpu * 100.0); // Convert (12.34%) 12.34 -> 1234
        Log("System Cpu: %d.%d%%\n", cpuInt / 100, cpuInt % 100);
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(m_printFreqMs) );
    } while( !m_doShutdown );

    Log("Finished!\n");
    return true;
}

// GetName
const char* CpuUsage::GetName() const NN_NOEXCEPT
{ return "CpuUsage"; }

}} // Namespace NATF::Modules

#endif // Win32
