﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

typedef unsigned int UINT4;

class MD5Hash
{
public:

    static const unsigned HASH_SIZE = 16;

    class Result
    {
    public:

        Result() NN_NOEXCEPT;
        Result(unsigned char n1,  unsigned char n2,  unsigned char n3,  unsigned char n4,
               unsigned char n5,  unsigned char n6,  unsigned char n7,  unsigned char n8,
               unsigned char n9,  unsigned char n10, unsigned char n11, unsigned char n12,
               unsigned char n13, unsigned char n14, unsigned char n15, unsigned char n16 ) NN_NOEXCEPT;

        void Set(unsigned char n1,  unsigned char n2,  unsigned char n3,  unsigned char n4,
                 unsigned char n5,  unsigned char n6,  unsigned char n7,  unsigned char n8,
                 unsigned char n9,  unsigned char n10, unsigned char n11, unsigned char n12,
                 unsigned char n13, unsigned char n14, unsigned char n15, unsigned char n16 ) NN_NOEXCEPT;

        void operator=(const Result& rhs);
        bool operator==(const Result& rhs);

        // Expected format: "a1 b2 c3 b4..."
        explicit Result(const char* pHashString) NN_NOEXCEPT;

        unsigned char m_pHash[HASH_SIZE];
    };

    MD5Hash() NN_NOEXCEPT;
    void Update(const unsigned char *input, unsigned int inputLen) NN_NOEXCEPT;
    void Final(Result& result) NN_NOEXCEPT;

private:

    void _Transform(const unsigned char block[64]) NN_NOEXCEPT;

    UINT4 _state[4];                                   /* state (ABCD) */
    UINT4 _count[2];        /* number of bits, modulo 2^64 (lsb first) */
    unsigned char _buffer[64];                         /* input buffer */
};
