﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef __EXCHANGE_INFO_H__
#define __EXCHANGE_INFO_H__

#include <nn/nn_Common.h>

#define EXCHANGE_INFO_FAIL() \
do                           \
{                            \
    NN_LOG("\n\n * Error!"); \
    NN_LOG(" * File: %s\n", __FILE__); \
    NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
    isSuccess = false;       \
    goto out;                \
} while( NN_STATIC_CONDITION(false) )

#define EXCHANGE_INFO_FAIL_IF(CONDITION, ...) \
do                                            \
{                                             \
    if( CONDITION )                           \
    {                                         \
        NN_LOG("\n\n * Error!");              \
        NN_LOG(" * File: %s\n", __FILE__);    \
        NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
        NN_LOG(" * ");                        \
        NN_LOG(__VA_ARGS__);                  \
        isSuccess = false;                    \
        goto out;                             \
    }                                         \
} while( NN_STATIC_CONDITION(false) )

namespace NATF {
namespace Utils {

class ExchangeInfo
{
public:

    bool Exchange() NN_NOEXCEPT;
    const char* GetLocalIp() const NN_NOEXCEPT;
    const char* GetRemoteIp() const NN_NOEXCEPT;

    static const char * const SessionServerHost;
    static const char * const SessionServerPort;
    static const char * const SdevServerName;
    static const char * const TicsSessionName;
    static const uint32_t IpBufLen = 16;

private:
    class HtcsExchangeInfoSession;

    char m_pRemoteIpStr[IpBufLen];
    char m_pLocalIpStr[IpBufLen];
};

}} // Namespaces NATF::Utils

#endif //__EXCHANGE_INFO_H__
