﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/SoTestDataXferModule.h"

namespace NATF {
namespace Tests {

    class TcpUdpLoopback : public BaseTest
    {
        NN_DISALLOW_COPY(TcpUdpLoopback);

    public:
        TcpUdpLoopback(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, uint32_t portNumber, const char* protocolTypeName, uint32_t durationSec, uint32_t connectionCount, const char* clientXferPattern, const char* serverXferPattern) NN_NOEXCEPT;
        virtual ~TcpUdpLoopback() NN_NOEXCEPT NN_OVERRIDE;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        static const uint32_t MaxConnectionCount = 16;

        Modules::SoTestDataXfer* m_pServers[MaxConnectionCount];
        Modules::SoTestDataXfer* m_pClients[MaxConnectionCount];
        uint32_t m_timeoutMs;
        uint32_t m_portNumber;
        char m_protocolTypeName[Modules::SoTestDataXfer::MaxNameStringLen];
        uint32_t m_durationSec;
        uint32_t m_connectionCount;
        char* m_clientXferPattern;
        char* m_serverXferPattern;
    };

} // namespace Tests
} // namespace NATF
