﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/SslAbuseModule.h"

namespace NATF {
namespace Tests {

    class SslAbuse : public BaseTest
    {
        NN_DISALLOW_COPY(SslAbuse);

    public:
        SslAbuse(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, const char* pHostName, uint16_t portNum, const char* pServerCertPath) NN_NOEXCEPT;
        virtual ~SslAbuse() NN_NOEXCEPT NN_OVERRIDE;

        static const uint32_t MaxHostNameLen = 64;
        static const uint32_t PathBufLen = 256;

    private:
        virtual bool Init() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        Modules::SslAbuse* m_pModule;
        uint16_t m_portNum;
        uint32_t m_timeoutMs;

        char m_pHostName[MaxHostNameLen];
        char m_pServerCertPath[PathBufLen];

        bool AllocateModules() NN_NOEXCEPT;
        void FreeModules() NN_NOEXCEPT;
    };

} // namespace Tests
} // namespace NATF
