﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/HttpServerModule_Win.h"
#include "Modules/CpuUsageModule_Win.h"

namespace NATF {
namespace Tests {

    class HttpServer : public BaseTest
    {
        NN_DISALLOW_COPY(HttpServer);

    public:
        HttpServer(const char* pTestName, bool useSsl, uint32_t durationSec, uint16_t portNum, uint32_t cpuFreqMs, bool authClient, bool quitOnError) NN_NOEXCEPT;
        virtual ~HttpServer() NN_NOEXCEPT NN_OVERRIDE;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        uint32_t m_durationSec;
        uint16_t m_portNum;
        uint32_t m_cpuFreqMs;
        bool m_useSsl;
        bool m_authClient;
        bool m_quitOnError;
        Modules::HttpServer* m_pHttpServer;
        Modules::CpuUsage*   m_pCpuUsage;
    };

} // namespace Tests
} // namespace NATF
