﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/LibCurlModule.h"

namespace NATF {
namespace Tests {

    class CurlHttpUpload : public BaseTest
    {
        NN_DISALLOW_COPY(CurlHttpUpload);

    public:
        CurlHttpUpload(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, uint32_t connectionCount, const NATF::Modules::LibCurl::Params& params) NN_NOEXCEPT;
        virtual ~CurlHttpUpload() NN_NOEXCEPT NN_OVERRIDE;

    private:
        virtual bool Init() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        bool AllocateModules() NN_NOEXCEPT;
        void FreeModules() NN_NOEXCEPT;

        Modules::LibCurl* m_pModules;
        uint32_t m_timeoutMs;
        uint32_t m_connectionCount;

        NATF::Modules::LibCurl::Params m_params;
    };

} // namespace Tests
} // namespace NATF
