﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/LibCurlModule.h"

namespace NATF {
namespace Tests {

    class CurlHttpUploadDownload : public BaseTest
    {
        NN_DISALLOW_COPY(CurlHttpUploadDownload);

    public:
        CurlHttpUploadDownload(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, bool doInit, const char* pDownloadUrl, const char* pUploadUrl, const Modules::LibCurl::Params& moduleParams) NN_NOEXCEPT;
        virtual ~CurlHttpUploadDownload() NN_NOEXCEPT NN_OVERRIDE;

        static const Utils::InitApiFlags InitFlags;

    private:
        virtual bool Init() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        bool AllocateModules() NN_NOEXCEPT;
        void FreeModules() NN_NOEXCEPT;

        uint32_t m_timeoutMs;
        Modules::LibCurl* m_pHttpDown;
        Modules::LibCurl* m_pHttpUp;

        Modules::LibCurl::Params m_params;
        char m_pDownloadUrl[Modules::LibCurl::UrlBufferLen];
        char m_pUploadUrl[Modules::LibCurl::UrlBufferLen];
    };

} // namespace Tests
} // namespace NATF
