﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"
#include "Utils/md5.h"

namespace NATF {
namespace Modules {

class SoHttpDownload : public BaseModule
{
    NN_DISALLOW_COPY(SoHttpDownload);

public:
    SoHttpDownload(const char* pIp, unsigned short port, const char* pResource, const MD5Hash::Result& expectedHash, bool useSelect, bool doNnLinger) NN_NOEXCEPT;
    virtual ~SoHttpDownload() NN_NOEXCEPT NN_OVERRIDE {}

    virtual bool Run() NN_NOEXCEPT NN_OVERRIDE;
    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE;

private:
    const char* m_pIp;
    unsigned short m_port;
    const char* m_pResource;
    const MD5Hash::Result& m_expectedHash;
    MD5Hash::Result m_hashResult;
    bool m_IsDoNnLinger;

    bool GetServerPage(const char* pServerHostName, unsigned short serverPort, const char* pResource, MD5Hash::Result& hashResult) const NN_NOEXCEPT;
    bool ReceiveResponse(int socketFd, MD5Hash::Result& hashResult) const NN_NOEXCEPT;
    char* ParseHeader(char* pBuffer, unsigned bufSize, bool& isLastNewLine, bool& isCompleteHeader) const NN_NOEXCEPT;
    bool ConnectToServer(int socketFD, const char* pServerHostName, unsigned short portNum) const NN_NOEXCEPT;
    int CreateSocketWithOptions() const NN_NOEXCEPT;
    bool SendHttpRequest(int socketFD, const char* pResource) const NN_NOEXCEPT;
};

}
}
