﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"

namespace NATF {
namespace Modules {

class HttpServer : public BaseModule
{
private:
    NN_DISALLOW_COPY(HttpServer);

public:

    HttpServer(uint16_t port, uint32_t durationSec, bool useSsl, bool doAuthClient, bool quitOnError) NN_NOEXCEPT;
    virtual ~HttpServer() NN_NOEXCEPT NN_OVERRIDE;

    virtual bool Run() NN_NOEXCEPT NN_OVERRIDE;
    virtual const char* GetName() const NN_NOEXCEPT NN_OVERRIDE;

    void Fail() NN_NOEXCEPT;

private:

    class Helper;
    class Connection;

    char* m_pPageBuffer;
    uint16_t m_port;
    uint32_t m_durationSec;
    bool m_useSsl;
    bool m_doAuthClient;
    bool m_quitOnError;
    NetTest::Event m_hasFailure;
    bool m_isSuccess;
};

}
}
