﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdio>

#define NN_LOG(format, ...) printf(format, ##__VA_ARGS__)

#define NN_NETTEST_LOG(format, ...)               \
do{                                            \
    printf("[NetTest] " format, ##__VA_ARGS__); \
    fflush(stdout);                            \
}while(false)

#define NATF_LOG(format, ...) printf("[NATF]" format, ##__VA_ARGS__)

#define NETTEST_ABORT()         \
do {                            \
    NN_NETTEST_LOG(" ******** Program Aborted! ********\n File: %s\n Line: %d\n Function: %s\n\n", __FILE__, __LINE__, __FUNCTION__); \
    NetTest::SleepMs(1000);        \
    int _CRASH_IT_ = 0;         \
    **(int**)(&_CRASH_IT_) = 0; \
} while(false)

#define NN_ALIGNAS(X) __attribute__((aligned(X)))

#define NETTEST_SNPRINTF snprintf

typedef unsigned uint32_t;
typedef unsigned short uint16_t;
typedef unsigned char uint8_t;

#ifndef __FreeBSD__
typedef unsigned long long uint64_t;
#endif
