﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Macro.h>
#include <nn/TargetConfigs/build_Base.h>
#include <nnt/nntest.h>

#include "natf/Utils/md5.h"

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_CONTINUE_ON_FAILURE

#define PRINT_AND_CALL(CALL) \
do                           \
{                            \
    NN_LOG("%s\n", #CALL);   \
    CALL;                    \
} while( NN_STATIC_CONDITION(false) )

#define ERROR_IF_AND_ABORT(CONDITION, ...) \
do                                         \
{                                          \
    if( CONDITION )                        \
    {                                      \
        NN_LOG("\n\n * Error!");           \
        NN_LOG(" * File: %s\n", __FILE__); \
        NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
        NN_LOG(" * Errno: %d\n", nn::socket::GetLastError()); \
        NN_LOG(" * ");                     \
        NN_LOG(__VA_ARGS__);               \
        NN_LOG("\n\n");                    \
        isSuccess = false;                 \
        EXPECT_EQ(false, true);            \
        goto out;                          \
    }                                      \
} while( NN_STATIC_CONDITION(false) )

#define ERROR_IF_AND_CONTINUE(CONDITION, ...)           \
do                                         \
{                                          \
    if( CONDITION )                        \
    {                                      \
        NN_LOG("\n\n * Error!");           \
        NN_LOG(" * File: %s\n", __FILE__); \
        NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
        NN_LOG(" * Errno: %d\n", nn::socket::GetLastError()); \
        NN_LOG(" * ");                     \
        NN_LOG(__VA_ARGS__);               \
        NN_LOG("\n\n");                    \
        isSuccess = false;                 \
        EXPECT_EQ(false, true);            \
    }                                      \
} while( NN_STATIC_CONDITION(false) )

#define WARN_IF_AND_CONTINUE(CONDITION, ...)           \
do                                         \
{                                          \
    if( CONDITION )                        \
    {                                      \
        NN_LOG("\n\n * Warning!");           \
        NN_LOG(" * File: %s\n", __FILE__); \
        NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
        NN_LOG(" * Errno: %d\n", nn::socket::GetLastError()); \
        NN_LOG(" * ");                     \
        NN_LOG(__VA_ARGS__);               \
        NN_LOG("\n\n");                    \
    }                                      \
} while( NN_STATIC_CONDITION(false) )

#ifdef ENABLE_CONTINUE_ON_FAILURE
    #define ERROR_IF(CONDITION, ...) WARN_IF_AND_CONTINUE((CONDITION), __VA_ARGS__);

#else
    #define ERROR_IF(CONDITION, ...) ERROR_IF_AND_ABORT((CONDITION), __VA_ARGS__);
#endif

#define EXPECT_ERRNO(EXPECTED_ERR)              \
do                                              \
{                                               \
    nn::socket::Errno lastErrno = nn::socket::GetLastError(); \
    ERROR_IF(EXPECTED_ERR != lastErrno, "Unexpected error value from nn::socket::GetLastError(). Expected: %s(%d), Returned: %d\n\n", #EXPECTED_ERR, EXPECTED_ERR, lastErrno); \
    nn::socket::SetLastError(nn::socket::Errno::ESuccess); \
} while( NN_STATIC_CONDITION(false) )

#define EXPECT_HERRNO(EXPECTED_ERR)              \
do                                              \
{                                               \
    nn::socket::HErrno *hErrno = nn::socket::GetHError(); \
    ERROR_IF(static_cast<nn::socket::HErrno *>(nullptr) == hErrno, "EXPECT_HERRNO: precondition failed (hErrno nullptr)"); \
    ERROR_IF(EXPECTED_ERR != *hErrno, "Unexpected error value from GetHError(). Expected: %s(%d), Returned: %d\n\n", #EXPECTED_ERR, EXPECTED_ERR, *hErrno); \
    *hErrno = nn::socket::HErrno::Netdb_Success; \
} while( NN_STATIC_CONDITION(false) )

#ifdef NN_BUILD_CONFIG_OS_WIN32
    #define EXPECT_ERRNO_WIN(ERROR_VALUE) \
    EXPECT_ERRNO(ERROR_VALUE);

    #define EXPECT_ERRNO_NX(ERROR_VALUE) \
    do                                    \
    {                                     \
    } while( NN_STATIC_CONDITION(false) )

    #define EXPECT_HERRNO_WIN(ERROR_VALUE) \
    EXPECT_HERRNO(ERROR_VALUE);

    #define EXPECT_HERRNO_NX(ERROR_VALUE) \
    do                                    \
    {                                     \
    } while( NN_STATIC_CONDITION(false) )
#else
    #define EXPECT_ERRNO_WIN(ERROR_VALUE) \
    do                                    \
    {                                     \
    } while( NN_STATIC_CONDITION(false) )

    #define EXPECT_ERRNO_NX(ERROR_VALUE) \
    EXPECT_ERRNO(ERROR_VALUE);

    #define EXPECT_HERRNO_WIN(ERROR_VALUE) \
    do                                    \
    {                                     \
    } while( NN_STATIC_CONDITION(false) )

    #define EXPECT_HERRNO_NX(ERROR_VALUE) \
    EXPECT_HERRNO(ERROR_VALUE);
#endif

#ifndef NN_BUILD_CONFIG_OS_WIN32
    #define NX_ONLY_ERROR_IF ERROR_IF
    #define NIFM_INIT_FAILURE_WORKAROUND(_bInitSuccess) \
    do { } while( NN_STATIC_CONDITION(false) )

#else
    #define NX_ONLY_ERROR_IF(CONDITION, ...)   \
    do                                         \
    {                                          \
        if( CONDITION )                        \
        {                                      \
            NN_LOG("\n\n * Warning!");         \
            NN_LOG(" * File: %s\n", __FILE__); \
            NN_LOG(" * Function: %s, Line %d\n", __FUNCTION__, __LINE__); \
            NN_LOG(" * ");                     \
            NN_LOG(__VA_ARGS__);               \
        }                                      \
    } while( NN_STATIC_CONDITION(false) )

    // TODO: when SIGLONTD-3127 remove this macro and all calls to it
    #define NIFM_INIT_FAILURE_WORKAROUND(__bInitSuccess)           \
    do                                                             \
    {                                                              \
        if( !(__bInitSuccess) )                                    \
        {                                                          \
            int err;                                               \
            WSADATA wsaData;                                       \
            err = WSAStartup(MAKEWORD(2, 2), &wsaData);            \
            if (err != 0)                                          \
            {                                                      \
                NN_LOG("WSAStartup failed with error: %d\n", err); \
                goto out;                                          \
            }                                                      \
        }                                                          \
    } while( NN_STATIC_CONDITION(false) )

#endif

namespace NATF {
namespace API {

    const uint32_t MaxIpStrLen   = 16;
    const uint32_t PollTimeoutMs = 10000;
    const uint16_t DefaultPort   = 8001;
    const uint32_t BufferLen     = 1024;

    enum
    {
        TestSetupOptions_Nifm = 0x0001,
        TestSetupOptions_Socket = 0x0004
    };

    bool TestSetup(unsigned int testSetupOptionsBitfield) NN_NOEXCEPT;
    bool TestTeardown() NN_NOEXCEPT;
    void FillBuffer(char* pBuffer, uint32_t dataPosition, uint32_t fillLen) NN_NOEXCEPT;
    bool WaitOnReadable(int socket, uint32_t timeoutMs) NN_NOEXCEPT;
    MD5Hash::Result CalcMd5(uint32_t dataLen) NN_NOEXCEPT;
    bool RecvData(int socket) NN_NOEXCEPT;
    bool SendData(int socket, uint32_t dataLen) NN_NOEXCEPT;

}} // NATF::API
