﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

namespace RecvFromTestEnvironment {

    typedef struct
    {
        int socketFd;
        nn::socket::SockAddrIn serverAddr;
        int sendToFlags;
        int sendToBytesToSend;
        int sendToBytesToExpect;
        int expectedClientDurationMs;
        int expectedClientErrno;
    } HostEnvironmentType;

    typedef struct
    {

    } ClientEnvironmentType;

    typedef struct
    {
        nn::os::MutexType mutex;
        bool isDone;
        int lastErrno;
        bool isVerbose;
        int threadId;
        bool withSetSockOpt;
        int setSockOptLevel;
        int setSockOptName;
        int setSockOptValue;
        int recvFromOption;
        int recvFromFlags;
    } ClientArgumentType;

    typedef struct
    {
        HostEnvironmentType hostEnvironment;
        ClientEnvironmentType clientEnvironment;
        nn::os::ThreadType clientThread;
        ClientArgumentType clientArgument;
    } TestEnvironmentType;

    bool GetNextTestEnvironment(TestEnvironmentType **ppEnvironment) NN_NOEXCEPT;
    bool SetupHostEnvironment(TestEnvironmentType *pTestEnvironment, int sendToFlags, int sendToBytesToSend, int sendToBytesToExpect, int expectedClientDurationMs, int expectedClientErrno) NN_NOEXCEPT;
    bool SetupClientArgument(TestEnvironmentType *pTestEnvironment, int setSockOptLevel, int setSockOptName, int setSockOptValue) NN_NOEXCEPT;
    bool StartHostEnvironment(TestEnvironmentType *pTestEnvironment) NN_NOEXCEPT;
    bool GetThreadArgumentIsDone(ClientArgumentType *pClientArgument, bool *pIsDone) NN_NOEXCEPT;
    bool SetThreadArgumentIsDone(ClientArgumentType *pClientArgument, bool isDone) NN_NOEXCEPT;
    bool GetThreadArgumentLastErrno(ClientArgumentType *pClientArgument, int *pLastErrno) NN_NOEXCEPT;
    bool SetThreadArgumentLastErrno(ClientArgumentType *pClientArgument, int lastErrno) NN_NOEXCEPT;
    bool PrintThreadArgument(ClientArgumentType *pClientArgument) NN_NOEXCEPT;
    void SetupBaseTestEnvironment() NN_NOEXCEPT;
    bool SetupNextTestEnvironment(TestEnvironmentType **ppTestEnvironment, int sendToFlags, int sendToBytesToSend, int sendToBytesToExpect, int expectedClientDurationMs, int expectedClientErrno, int setSockOptLevel, int setSockOptName, int setSockOptValue, int recvFromOption, int recvFromFlags) NN_NOEXCEPT;

} // RecvFromTestEnvironment
