﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#include <cstdio>     // sprintf
#include <cctype>     // isprint
#include <cstdlib>    // malloc

#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nn/socket.h>
#include <nnt/nntest.h>

namespace NATF {
namespace API {

/////////////////////////
//  C O N S T A N T S
/////////////////////////


/////////////////////////
// EchoServer
/////////////////////////

class EchoServer
{
    public:

        //////////////
        //  Constants
        //////////////

        static const char *      kInterfaceIPv4Addr;           // IP Address on Interface to use

        static const uint16_t    kEchoServerUDPPort = 8053;    // UDP port to listen on
        static const uint16_t    kEchoServerTCPPort = 8053;    // TCP port to listen on
        static const nn::Bit64   kEchoServerCore = 1;          // Run on NX Core 1

        static const size_t      kEchoServerMaxReceiveSize = 65535;
        static const size_t      kSocketArrLen = 32;

        ///////////////
        // Array of FDs
        ///////////////

        int                      socketArr[kSocketArrLen];

        //////////////
        //  Setables
        //////////////

        int                       threadId;
        uint16_t                  echoServerUDPPort;
        uint16_t                  echoServerTCPPort;
        nn::Bit64                 echoServerCore;

        //////////////
        //  Switches
        /////////////

        bool                      echoServerShouldRun;         // true if DNS server (should run)
        bool                      echoServerRunning;           // true if DNS server (is running)
        bool                      falseEchoMode;               // true if don't echo response

        //////////////
        // Receive Buffer
        //////////////

        unsigned char *           recvPtr;
        size_t                    recvPtrLen;

        //////////////
        //  Socket Fds
        //////////////

        int                       serverUDP;
        int                       serverTCP;
        int                       acceptedTCP;

        ////////////////////////////
        //  Socket Address Structs
        ////////////////////////////

        nn::socket::SockAddrIn        udpAddr;
        nn::socket::SockLenT                 udpAddrSize;

        nn::socket::SockAddrIn        tcpAddr;
        nn::socket::SockLenT                 tcpAddrSize;

        nn::socket::SockAddrIn        recvAddr;
        nn::socket::SockLenT                 recvAddrSize;

        ////////////////////////////
        //  DNS method Callbacks
        ////////////////////////////


        // Constructor
        EchoServer();

        // Constructor with Args
        EchoServer( uint16_t    udpPort,
                    uint16_t    tcpPort,
                    nn::Bit64   core,
                    size_t      recvSize );

        // Destructor
        virtual ~EchoServer();

        void PrintHex( unsigned char *    buff,
                       size_t &           buffLen,
                       bool *             isReq,
                       bool *             isUDP );

        // Thread start DNS Server
        void Start( void *  arg);

        // Stop DNS Server
        int Stop();

        //
        inline void setFalseEcho( bool    inArg)
        {
            falseEchoMode = inArg;
        }
};

}}   // namespace: NATF/API
