﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace NATF {
namespace API {
namespace COMMON {

    // Set Non-Blocking Socket I/O on a socket
    //
    // Returns: 0 or -1
    int SetNonBlocking( int   sockfds );

    // Set Blocking Socket I/O on a socket
    //
    // Returns: 0 or -1
    int SetBlocking( int   sockfds );

    // Make a UDP Connection to another UDP Socket
    //
    // Returns:  UDP Socket FD
    int MakeUDPConnection(  const char *  sourceHost, uint16_t   sourcePort,
                            const char *  targetHost, uint16_t   targetPort ) NN_NOEXCEPT;

    // Make a TCP Connection to another TCP Socket
    //
    // Returns:  UDP Socket FD
    int MakeTCPConnection( const char *  targetHost, uint16_t   targetPort ) NN_NOEXCEPT;

    // Make a TCP Listen Socket
    //
    // returns: Listen Fds
    bool MakeListenSocket( int & sockfds, int inPort, const char * inInterface ) NN_NOEXCEPT;

    // Make a Random 8 bit buffer.
    //
    // Returns: 0 or -1
    int MakeRandomNoise( unsigned char ** rtrnPtr, size_t rtrnPtrSize, uint8_t & startpos ) NN_NOEXCEPT;

    // Write data to a FDS
    //
    // Returns: Bytes Wwritten - or -1
    int WriteData( int sockfds, unsigned char * outBuff, size_t outBuffLen,
                   uint64_t &   writeWouldBlock, uint64_t &  writeNotFull ) NN_NOEXCEPT;

    // Write data to a FDS
    //
    // Returns: Bytes Read - or -1
    int ReadData( int sockfds, unsigned char * outBuff, size_t outBuffLen,
                  uint64_t & readWouldBlock ) NN_NOEXCEPT;

    // Set Socket Option -- and then Bind + Connect
    //
    // Returns: true / false
    bool SetSocketOptAndConnect( int & sockfds, nn::socket::Level socklevel, nn::socket::Option sockopt, void * opt,
                                 nn::socket::SockLenT & optlen, int localPort,  const char * localInterface,
                                 int targetPort, const char * targetInterface, bool isUDP,
                                 int expectedRC ) NN_NOEXCEPT;

    // Get TICKs now in Seconds
    uint64_t GetTicksInSeconds() NN_NOEXCEPT;

    // Get TICKs now in MicoSeconds
    uint64_t GetMicroSeconds() NN_NOEXCEPT;

    // Checks Boolean options on SetSockOpt/GetSockOpt
    bool CheckBooleanSetSockOpt(int sockfds, nn::socket::Level inSocklevel, nn::socket::Option inSockopt, bool isEnabled, int inValue) NN_NOEXCEPT;

    // Checks Numeric options on SetSockOpt/GetSockOpt
    bool CheckNumericSetSockOpt(int sockfds, nn::socket::Level inSocklevel, nn::socket::Option inSockopt, bool isValid, int inValue) NN_NOEXCEPT;

    // Check struct timeval on SetSockOpt/GetSockOpt
    bool CheckTimevalSetSockOpt(int sockfds, nn::socket::Level inSocklevel, nn::socket::Option inSockopt, bool isValid, nn::socket::TimeVal inValue) NN_NOEXCEPT;

}}} // NATF::API::COMMON
