﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/socket.h>
#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nnt.h>

#include <mutex>

#include "testNet_ApiCommon.h"
#include "Complex/testNet_UnitCommon.h"

namespace NATF {
namespace API {

/**
 * @brief the test thread
 */
class PollBeforeConnectTestThread :
        public virtual UnitTestThreadBase
{
public:
   /**
    * @brief ctor
    * @param sockfd the socket to set into a poll event
    * @param events the events for poll (i.e. POLLIN, POLLPRI, etc)
    * @param pollTimeoutInSeconds the timeout given for poll
    * @param waitForDoneTimeoutInSeconds the timeout given for WaitForDoneWithTimeout
    */
    PollBeforeConnectTestThread(SimpleValidator* pSimpleValidator,
                                int sockfd,
                                nn::socket::PollEvent events,
                                int pollTimeoutInSeconds,
                                int waitForDoneTimeoutInSeconds,
                                int pollExpectedReturnValue);

    /**
     * @brief wait for the testto complete, or the timeout value to happen, also provide
     * whether the socket closed. If not then you must call Interrupt to close it
     */
    virtual bool WaitOrTimeoutGetSocketClose(bool shouldComplete, bool & didSocketClose);

   /**
    * @brief Interrupt thread by closing the socket
    * @return 0 if able to interrupt -1 if the thread was already done
    */
    virtual int Interrupt();

protected:
    /** @brief dtor */
    virtual ~PollBeforeConnectTestThread();

    /** @brief run function, waits for testTimeout or signal */
    virtual void Run();

private:
    /** @brief the validator */
    SimpleValidator* m_pValidator;

    /** @brief the socket */
    int m_Sockfd;

    /** @brief events for poll */
    nn::socket::PollEvent m_PollEvents;

    /** @brief the timeout in seconds */
    int m_PollTimeoutInSeconds;

    /** @brief wait for done timeout */
    int m_waitForDoneTimeoutInSeconds;

    /** @brief the return value from poll */
    int m_PollReturnValue;

    /** @brief the expected return value for poll */
    int m_PollExpectedReturnValue;

    /** @brief access lock for manager */
    mutable std::mutex m_AccessLock;
};

}};
