﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/socket.h>
#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nnt.h>

#include <mutex>

#include "testNet_ApiCommon.h"
#include "Complex/testNet_UnitCommon.h"

namespace NATF {
namespace API {

/**
 * @brief the test thread
 */
class BroadcastDatagramWorkerThread :
        public virtual UnitTestThreadBase
{
public:
    /**
     * @brief ctor
     * @param pSimpleValidator a pointer to the validator object
     */
    BroadcastDatagramWorkerThread(SimpleValidator* pSimpleValidator,
                                  bool isProducer,
                                  unsigned datagramCount,
                                  unsigned producerSleepTime,
                                  uint16_t port,
                                  bool useOnesCompliment);


protected:
    /** @brief dtor */
    virtual ~BroadcastDatagramWorkerThread();

    /** @brief run function, waits for testTimeout or signal */
    virtual void Run();

    /**
     * @brief produce some data
     * also must verify the broadcast didn't come from somewhere else
     * so data, so use the ip address as the data
     */
    virtual void Produce();

    /** @brief consume some data */
    virtual void Consume();

private:
    /** @brief the validator */
    SimpleValidator* m_pValidator;

    /** @brief if true then a producer else a consumer*/
    bool m_IsProducer;

    /** @brief the count of datagrams to send or receive until timeout */
    unsigned m_DatagramCount;

    /** @brief amount of time to sleep in milliseconds between operations */
    unsigned m_ProducerSleepTimeInMilliseconds;

    /** @brief the socket address */
    nn::socket::SockAddrIn m_Addr;

    /** @brief the port */
    uint16_t m_Port;

    /** @brief the socket */
    int m_Sockfd;

    /** @brief whether or not to use nn::socket::OptionName_Ip_OnesBcast mode*/
    bool m_UseOnesCompliment;

    /** @brief ip addr */
    nn::socket::InAddr m_IpAddress;

    /** @brief ip addr mask */
    nn::socket::InAddr m_IpAddressMask;

    /** @brief access lock for manager */
    mutable std::mutex m_AccessLock;

    /** @brief total time for the Consumer to wait */
    static const unsigned s_ConsumerTimeoutSeconds = 5;
};

}};
