﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <numerical/nerd_numerical_vector.h>

#include <picore/nerd_intrinsics.h>
#include <pirencore/nerd_contiguous_storage_container.h>
#include <type_traits>

namespace nerd {

template<typename T>
struct TemplateSensorSample
{
    static_assert(std::is_arithmetic<T>::value, "");
    typedef NumericalVector<T, 3> vector3;
    u64 timestamp{ 0 };

    vector3 Rotation{ 0 };
    vector3 Acceleration{ 0 };

};

typedef TemplateSensorSample<s16> CSVRawSensorSample;

template<typename T>
struct TemplateSensorCapture
{
    ContiguousStorageContainer<TemplateSensorSample<T>> Data;
};

typedef TemplateSensorCapture<s16> HostSensorCapture;
typedef TemplateSensorCapture<float> CSVRawSensorSampleF;

HostSensorCapture ReadHostSensorCaptureFromCSV(std::string const& csvData);

template<typename scal>
struct PreparedSensorData
{
    typedef NumericalVector<scal, 3> vector3;
    ContiguousStorageContainer<vector3> omegas;
    ContiguousStorageContainer<scal> dts;
    ContiguousStorageContainer<vector3> localAccels;
};

template<typename scal>
PreparedSensorData<scal> PrepareRawData(HostSensorCapture const& capture, u32 const downSample);
PreparedSensorData<float> LoadData(char const* path, int downsample = 1);


}
