﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>

#include <nn/ndd.h>

#define TEST_LOG(format, ...) NN_LOG("[testNdd_Sample]" format, ##__VA_ARGS__)

extern "C" void nnMain()
{
    TEST_LOG("Start Sample\n");

    nn::ndd::Initialize();

    //送信設定
    {
        TEST_LOG("Setup Send\n");
        nn::os::SystemEventType sendDataUpdateEvent;
        nn::ndd::AcquireSendDataUpdateEvent(&sendDataUpdateEvent);

        nn::ndd::SendDataDescription sendDataDescription;
        memset(&sendDataDescription.data[0], 0xAA, 1);
        sendDataDescription.dataSize  = 1;
        memset(&sendDataDescription.dataId.raw[0], 0xBB, nn::ndd::DataIdSize);
        nn::os::ClearSystemEvent(&sendDataUpdateEvent);
        nn::ndd::AddSendData(sendDataDescription);
        nn::os::WaitSystemEvent(&sendDataUpdateEvent);
    }

    //受信シミュレーション
    {
        TEST_LOG("Simulate Receive\n");
        nn::ndd::ReceiveDataDescription receiveDataDescription;
        memset(&receiveDataDescription.data[0], 0xBB, 1);
        receiveDataDescription.dataSize  = 1;
        receiveDataDescription.receiveTime = 0;
        nn::ndd::AddReceiveData(receiveDataDescription);
    }

    //受信設定
    {
        TEST_LOG("Setup Receive\n");
        nn::os::SystemEventType receiveDataEvent;
        nn::ndd::AcquireReceiveDataEvent(&receiveDataEvent);
        nn::os::WaitSystemEvent(&receiveDataEvent);

        auto counter = nn::ndd::GetOldestReceiveDataCounter();
        TEST_LOG("OldestCounter = %d\n", counter);
        for(;;)
        {
            nn::ndd::ReceiveDataDescription receiveDataDescription;
            auto resultCount = GetReceiveData(&receiveDataDescription, &counter, counter, 1);
            if(resultCount == 0)
            {
                break;
            }
            TEST_LOG("Receive Data: time = %d, size = %d, data[0] = 0x%02X\n",
                    receiveDataDescription.dataSize, receiveDataDescription.receiveTime, receiveDataDescription.data[0]);
            TEST_LOG("NextCounter = %d\n", counter);
        }
        TEST_LOG("Finish Sample\n");
    }
}
