﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/la/la_Api.h>
#include <nn/la/la_CommonArgumentsWriter.h>

#include <nnt.h>

using namespace nn;

extern "C" void nnMain()
{
    la::CommonArgumentsWriter commonArgumentsWriter(0);

    applet::LibraryAppletHandle libraryAppletHandle;
    NNT_ASSERT_RESULT_SUCCESS(applet::CreateLibraryApplet(&libraryAppletHandle, applet::AppletId_LibraryAppletEncounter, applet::LibraryAppletMode_AllForeground));

    commonArgumentsWriter.PushToInChannel(libraryAppletHandle);

    applet::StartLibraryApplet(libraryAppletHandle);
    applet::JoinLibraryApplet(libraryAppletHandle);

    applet::CloseLibraryApplet(libraryAppletHandle);
}
